

#include <conio.h>
#include <wgt4.h>
#include <wgtvesa.h>
#include <dos.h>
#include <printer.h>
block wgt;                    /* Pointer to our first image to load */
color pale[256];               /* Our color palette */



void printimage()
{

	/* install defaults */
	Verbose = FALSE;        /* not verbose */
	Brightness = 0; /* use calculated brightness */
	PrintMode = POSPRINT;   /* print whites as white */
	Matrix = BayerMatrix;   /* use BayerMatrix */


/* Print the image displayed on the screen */
PrtScreen(PrintMode,3);  /*1=320x200,2=640x200,3=640x400*/

}




int which_string(int mode)
{
  /* This function simply returns a string number to display based on the
     highlighted video mode */
  switch (mode)
  {
    case V640x400   : return 0;
    case V640x480   : return 1;
    case V800x600   : return 2;
    case V1024x768  : return 3;
    case V1280x1024 : return 4;
  }
  return 0;
}




void main(void)
{
  int oldmode;                  /* Video mode before program was started */
  int mymode = 0;               /* Selected video mode */

  oldmode = wgetmode ();        /* Preserve our original video mode */
  clrscr();                     /* Clear the screen */
  if (!wvesa_detected())         /* Look for VESA driver */
  {
    printf("SVGA support not found. Please check for VESA driver presence.\n");
    exit(1);
  }

    mymode = V640x400;

  vga256();
  if (!wvesa_init(mymode))
  {
    printf("Unable to initialize graphics mode.\n");
    exit(1);
  }

//  wvesa_clip (50, 90, 490, 380);	/* Add this line for clipping */

  wgt = wloadpcx256("map1a.pcx",pale);		/* Load our images */
  wsetpalette(0, 255, pale);
  wvesa_cls (0);
  wvesa_putblock(0,0,wgt,0);
  wgt = wloadpcx256("map1b.pcx",pale);		/* Load our images */
  wvesa_putblock(320,0,wgt,0);
  wfreeblock(wgt);
  wgt = wloadpcx256("map1e.pcx",pale);		/* Load our images */
  wvesa_putblock(0,191,wgt,0);
  wfreeblock(wgt);
  wgt = wloadpcx256("map1f.pcx",pale);		/* Load our images */
  wvesa_putblock(320,191,wgt,0);
  wfreeblock(wgt);
  getch();
  printimage();
  wsetmode(oldmode);			/* Return text mode */
}

