
#include <array.h>
#include <cstring.h>

#define	KS_ENTER			0x1C
#define	KS_UP				0x48
#define	KS_LEFT			0x4B
#define	KS_RIGHT       0x4D
#define	KS_DOWN			0x50

typedef	unsigned char	uchar;
typedef	unsigned short	ushort;
typedef	unsigned long	ulong;
typedef unsigned char*  string;
enum bool {
	false = 0,
	true = 1
};

class TColor {
	private:
		uchar	Foreground:4;
		uchar	Background:3;
		uchar	Blink:1;
	public:
		TColor ( uchar fg = 7, uchar bg = 0, bool bl = false);
		~TColor (void);
		void SetFg (uchar fg);
		void SetBg (uchar bg);
		void SetBl (bool bl);
		uchar GetFg (void);
		uchar GetBg (void);
		bool GetBl (void);
		uchar GetColorByte (void);
		void SetColorByte (uchar uColor);
};

class TWindow {
	protected:
		ushort x;
		ushort y;
		ushort width;
		ushort height;
		ushort* underneath;
		string title;
	public:
		TWindow (ushort X1, ushort Y1, ushort X2, ushort Y2,
				string& Title);
		~TWindow(void);
		void PutChar (ushort xpos, ushort ypos, uchar ch);
		void PutText (ushort xpos, ushort ypos, string& text);
		void CenterText (ushort ypos, string& text);
		void PutLongText (ushort ypos, string& text);
		void CenterHighlightText (ushort ypos, string& text);
		void HighlightLine (ushort ypos, ushort X1, ushort X2);
		virtual void Run (void);
		void Clear (void);
};

class TSetupApp {
	protected:
		string Title;
	public:
		TSetupApp ( string &title=string("DSPI Setup Application") );
		~TSetupApp (void);
		virtual void Run (void);
		void Paint (void);
		void PutChar (ushort x, ushort y, uchar ch);
		uchar GetChar (ushort x, ushort y, TColor& col);
		void PutText (ushort x, ushort y, string& text);
		void ExecWindow (TWindow& window);
};

class TListWindow : public TWindow {
	protected:
		bool				Exit;
		ushort			numitems;
		ushort   		current;
		array<string>  items;
		ushort			defaultitem ;
	public:
		TListWindow (ushort X1, ushort Y1, ushort X2,
				ushort Y2, string& Title);
		~TListWindow (void);
		void Insert (string& item);
		virtual void OnSelection (ushort sel)=0;
		virtual void OnKeyTo (ushort sel)=0;
		virtual void Run (void);
};

class TInputWindow : public TWindow {
	protected:
		string*	Input;
	public:
		TInputWindow ( ushort X1, ushort Y1, ushort X2,
				string& Title, string* input);
		~TInputWindow (void);
		void Run (void);
};

void SetupScreen (void);
void PutChar (ushort x, ushort y, uchar ch, TColor& color);
ushort GetFullChar (ushort x, ushort y);
void PutFullChar (ushort x, ushort y, ushort ch);
#ifdef __DPMI32__
extern 	ushort uScreenSel;
#endif
void PutText (ushort x, ushort y, string& str, TColor& color);
uchar GetKeyScanCode (void);

extern TColor	title_default;			// Title bar
extern TColor	bg_default;				// Background
extern TColor	dialog_default;		// Dialog boxes
extern TColor	border_default;		// Dialog borders
extern TColor	highlight_default;   // Highlighted text

