
#ifndef __BYTE
#define __BYTE
typedef unsigned char BYTE;
#endif
#define TRUE 1;
#define FALSE 0;

	#define POSPRINT 1   /* pixel over threshold prints black */
	#define NEGPRINT 0  /* pixel over threshold prints white */

/* printer status equates */
	#define PRTTIMEOUT      0x01
	#define PRTBUSYBIT      0x80 /* msb of printer status is busy bit */
	#define PRINTERINT      0x17 /* printer BIOS interrupt 17H number */
	#define PRTCHARCODE     0 /* int 17H print character func. code */
	#define INITPRTCODE     1 /* int 17H initialize printer func. code */
	#define GETPRTSTATUSCODE 2      /* int 17H get printer status func. code */
	#define LPT1 0 /* printer select codes for    BIOS */
	#define LPT2 1
	#define LPT3 2
	#define PIXELSPERPASS 8 /* 8 pixel printed per print head pass */
#define LRMAXCOLS 320
#define LRMAXROWS 200
#define LRVIDEOMODE 1
#define MRMAXCOLS 640
#define MRMAXROWS 200
#define MRVIDEOMODE 2
#define HRMAXCOLS 640
#define HRMAXROWS 480
#define HRVIDEOMODE 3
#define SCREENWIDTHINCHES (double) 9.500
#define SCREENHEIGHTINCHES (double) 7.125

#define MAXVGAINTVAL 6300.0     /* Max VGA intensity x 100 */
#define MAXPRTINTENSITIES 17    /* 17 possible densities in 4x4 matrix */
#define MAXDENSITYINDEX (MAXPRTINTENSITIES-1)
	/* LJ-GRAPH graphics output driver for laserjet printers*/
#define PORTRAIT 0      /*definitionsforPrint Graph*/
#define LANDSCAPE 1     /* image orientation */
#define GREYSCALE 2     /* and (olor to grey scale */

typedef enum {LowResMode, MedResMode, HighResMode} PrinterModes;
typedef enum {BayerMatrix, RylanderMatrix} MatrixType;
typedef int CompletionCode;

typedef struct
{
	BYTE Red;
	BYTE Green;
	BYTE Blue;
	}ColorRegister;
/* structure for holding a half tone dot pattern */
struct DotPatterns
{
BYTE Row1;
BYTE Row2;
BYTE Row3; 
BYTE Row4;
};

/* Version information */ 
static short ver = 1;
static short rel = 0;

/* print function variables */
static unsigned Verbose, PrintMode;
static int Brightness;
static unsigned MaxScreenRow, MaxScreenCol, Is256Colors;
static unsigned DensityTbl[256];
static unsigned N1,N2;
static union REGS regs;
static enum MatrixType Matrix;

/* The following arrays define the half tone patterns used
for the printout. 4x4 dither matrices are used in both
cases.
*/
static unsigned DensityTbl[256];
static char graph_ends[ ]="\x1B*rB";
/*static char graph_init[ ]="\x1B E\x1B&l1H\x1B&lO\x1B*p0X\x1B*p0Y\x1B*t";*/
static char graph_init[ ]="\x1B&l0O\x1B*p0X\x1B*p0Y\x1B*t";  

/* Function Declarations */
CompletionCode PrtScreen (unsigned NegPos,unsigned CurrentDisplayMode);
void laser_print(int, int);
void LJ_Graphic(int, int);
