
#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <wgt4.h>
#include <wgtflic.h>

#define ESC             27              /* ESCAPE KEY */
#define PLAY_DISK       0               /* Passed at command line */
#define PLAY_EMS        1               /* Passed at command line */

char         ch;                        /* Keyboard input */
int          playmode;                  /* EMS or disk playback */
int          filefound;                 /* 1 if the animation file was found */
struct ffblk ffblk;                     /* Stores filename and size */
int          oldmode;                   /* Previous video mode */
int          status;                    /* Status of FLI/FLC */

int          origdisk;                  /* Stores original drive */
char         origpath[MAXPATH];         /* Stores original path */


void changepath (char *pathname)
/* Changes to another disk and directory if needed. */
{
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];
  int  flags;
  int  len;

  flags = fnsplit (pathname, drive, dir, file, ext);

  if (flags & DRIVE)
    setdisk (toupper (drive[0]) - 65);
  if (flags & DIRECTORY)
  {
    len = strlen (dir);
    dir[len-1] = '\0';
    chdir (dir);
  }
}



void main (int argc, char *argv[])
{
  if ((argc < 2) || (argc > 3))         /* Display how to use this program */
  {
    printf ("\nNeed file\n");
    printf (" 0 - Play from disk (default)\n");
    printf (" 1 - Play from EMS\n");
    printf ("\nPress any key\n");
    getch ();
    exit (1);
  }

  filefound = findfirst (argv[1], &ffblk, 0);
  if (filefound == -1)
  {
    printf ("\nNo files matching %s were found!\n", argv[1]);
    exit (1);
  }

  origdisk = getdisk ();                /* Find current disk drive */
  getcwd (origpath, MAXPATH);           /* And the current pathname */

  changepath (argv[1]);                 /* Switch to another drive if needed */

  if (argc > 2)
    playmode = atoi (argv[2]);          /* Get playmode from command line */
  else playmode = PLAY_DISK;            /* Or default to disk */

  if (playmode == PLAY_EMS)
  {                        /* Make sure EMS is present and working correctly */
    if (!wems_present ())
    {
      printf ("\n EMS not found!\n");
      setdisk (origdisk);
      chdir (origpath);
      exit (1);
    }
    if (!wems_init ())
    {
      printf ("\nEMS initialization error!\n");
      setdisk (origdisk);
      chdir (origpath);
      exit (1);
    }
  }

  oldmode = wgetmode ();                /* Preserve initial video mode */
  vga256 ();                            /* Go to graphics mode */
  flicscreen = abuf;                    /* Set to visual screen */
					/* You must set this AFTER vga256(); */

  do {
    if (playmode == PLAY_EMS)           /* We are playing from EMS */
    {
      flic_mode = FLIC_EMS;
      if (!wems_open (ffblk.ff_fsize / 16384L + 4))  
      /* Allocate FLI/FLC memory buffer, add 4 pages to allow for remainder */
      {
	wsetmode (oldmode);
	printf ("\nNot enough EMS memory to load this animation!\n(%s)", ffblk.ff_name);
	setdisk (origdisk);
	chdir (origpath);
	exit (1);
      }  
    }
    else 
      flic_mode = FLIC_DISK;

    if (openflic (ffblk.ff_name) == FLIC_OK)    /* See if we opened file ok */
      do {
	status = nextframe ();                  /* Show frame of animation */
	if ((status != FLIC_OK))         /* && (status != FLIC_DONE))*/
	  break;                                /* Abort if error */
	delay (flichdr.speed);                  /* Delay proper amount */
      } while (!kbhit ());                      /* Continue until keypress */

    /* NOTE: If you don't want the flic to loop, remove the check for
	     FLIC_DONE. This will abort playback when the animation is done */

    while (kbhit())                             /* Get key from buffer */
      ch = getch ();

    closeflic ();                               /* Close current animation */
    wems_close ();                              /* Free the EMS memory */
    filefound = findnext (&ffblk);              /* Look for another file */
  } while ((ch != ESC) && (filefound != -1));
    while (!kbhit()) {
    }                           /* Get key from buffer */

  setdisk (origdisk);                           /* Return to original drive */
  chdir (origpath);                             /* and path */
  wsetmode (oldmode);                           /* and video mode */
}
