#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wgt4.h>
#include <dspi.h>
/*#include <alloc.h>*/
/*DS=SS and Auto Far Data in compile*/
#ifdef __DPMI32__
	#define  CONFIG   "MIDI32.CFG"
	#define  DRV      "32BIT"
#elif defined(__DPMI16__)
	#define  CONFIG   "MIDI16.CFG"
	#define  DRV      "16BIT"
#else
	#define  CONFIG   "MIDI.CFG"
	#define  DRV      "DRVR"
#endif

color normpalette[256];

static int MAP[41][26];
char citynameend[81];
static int citysize;  /*1=hamlet 2=village 3=town 4=sm city 5=med city 6=lg city*/
static int castle;
static int keap;
static int market;
static int walls;
static int terrain;
static int ADJECTIVES;
static int NOUNS;
int music;
FILE *fpmonst;
FILE *fpdesc;


  struct time time1, time2;

LPBYTE GetConfigString (void) {
	FILE *fp;
	DWORD dwLen;
	LPBYTE file;


	chdir("DRVR");
	fp = fopen ("MIDI.CFG", "rb");
	if (fp == NULL) {
		return NULL;
	}
	chdir("..");
	dwLen = filelength(fileno(fp));
	file = (LPBYTE)farmalloc(dwLen + 1);
	fread (file, 1, (WORD)dwLen, fp);
	fclose (fp);
	return file;

}


void soundset()
{
	LPBYTE lpString;
	MIDICAPS caps;
	lpString = GetConfigString();
	if ( lpString == NULL ) {
		printf ("ERROR: Unable to load file %s\n", CONFIG);
		return;
	}
	chdir("DRVR");
	if ( midiLoadDriver((LPSTR)lpString) != MIDI_ERROR_NONE ) {
		printf ("ERROR: Unable to load driver %s\n", lpString);
		chdir ("..");
		return;
	}
	chdir ("..");
	midiSetDriverSpecific ( lpString + 13 );
	if ( midiDriverEntry() != MIDI_ERROR_NONE ) {
		printf ("ERROR: Cannot initialize driver\n");
		return;
	}
	midiGetDeviceCaps (&caps);
}




void loadandplay(char *perrysong)
{
	SMF_0 File;
	HPBYTE lpFile;

	lpFile = midiLoadSMF (perrysong, &File);
	if (lpFile == NULL) {
		midiCloseDriver();
		printf ("ERROR: Unable to load midi file");
		return;
	}
	if ( midiPlaySMF (lpFile, &File) != MIDI_ERROR_NONE ) {
		midiCloseDriver();
		printf ("ERROR: Unable to play MIDI file\n");
		return;
	}
}




/***********READ DATA***************/
void readdata(void)
{
  int x,y;
  char item[81];

       fpmonst=fopen("temp\\cn.tmp","r");
		fgets(citynameend,81,fpmonst);
		fscanf(fpmonst,"%d",&citysize);
		fscanf(fpmonst,"%d",&terrain);
		fscanf(fpmonst,"%d",&castle);
		fscanf(fpmonst,"%d",&keap);
       fclose(fpmonst);

			    /*write array*/
	fpmonst=fopen("temp\\citym.tmp","rb");
	  for(x=0;x<=40;x++){
	    for(y=0;y<=25;y++){
	       fread(&MAP[x][y],sizeof(int),1,fpmonst);
	    }
	  }
	fclose(fpmonst);


	fpmonst=fopen("tables\\city\\adj.tbl","r");
	      for(;;){
		 if(feof(fpmonst)) break;
		 fgets(item,81,fpmonst);
		 if(item[0]=='*') break;
		 if(item[0]!='*') ADJECTIVES++;
		 if(feof(fpmonst)) break;
	      }
	fclose(fpmonst);

	fpmonst=fopen("tables\\city\\noun.tbl","r");
	      for(;;){
		 if(feof(fpmonst)) break;
		 fgets(item,81,fpmonst);
		 if(item[0]=='*') break;
		 if(item[0]!='*') NOUNS++;
		 if(feof(fpmonst)) break;
	      }
	fclose(fpmonst);

}

void writecityinfo(void)
{

fpmonst=fopen("text\\city.txt","w");

if(citysize==1) fprintf(fpmonst,
	"                         Hamlet of %s\n",citynameend);
if(citysize==2) fprintf(fpmonst,
	"                         Village of %s\n",citynameend);
if(citysize==3) fprintf(fpmonst,
	"                         Town of %s\n",citynameend);
if(citysize >3) fprintf(fpmonst,
	"                         City of %s\n",citynameend);
fprintf(fpmonst,"\n\n");
if(citysize==1) fprintf(fpmonst,"POPULATION: 1-200\n");
if(citysize==2) fprintf(fpmonst,"POPULATION: 201-500\n");
if(citysize==3) fprintf(fpmonst,"POPULATION: 501-1000\n");
if(citysize==4) fprintf(fpmonst,"POPULATION: 1001-2500\n");
if(citysize==5) fprintf(fpmonst,"POPULATION: 2501-4000\n");
if(citysize==6) fprintf(fpmonst,"POPULATION: 4001-10000\n");
if(terrain==1)  fprintf(fpmonst,"TERRAIN   : Forest\n");
if(terrain==2)  fprintf(fpmonst,"TERRAIN   : Mountains-Hills\n");
if(terrain==3)  fprintf(fpmonst,"TERRAIN   : Desert\n");
if(terrain==4)  fprintf(fpmonst,"TERRAIN   : Plains\n");
if(terrain==5)  fprintf(fpmonst,"TERRAIN   : Coastal\n");
fprintf(fpmonst,"\n\n");
fclose(fpmonst);
}


void findtype(int xx, int yy)
{
  int l,d,adj,noun,f;
  char item[81];
  char item2[81];
  char item3[81];
  l=MAP[xx][yy];
  d=0;
  if((l>0)&&(l<=135)){        /*map location is a building*/
	  fpmonst=fopen("text\\city.txt","a");
	  fprintf(fpmonst,"%-*.*d,%-*.*d       ",0,2,xx,12,2,yy);

    /*without names*/
	  if(l==1)   {sprintf(item3,"MOUNTAIN TRAPPER");d=1;}
	  if(l==2)   {sprintf(item3,"QUARY");d=1;}
	  if(l==8)   {sprintf(item3,"FORESTERS GUILD");d=1;}
	  if(l==3)   {sprintf(item3,"MINERS GUILD");d=1;}
	  if(l==15)  {sprintf(item3,"DAIRY");d=1;}
	  if(l==16)  {sprintf(item3,"DAIRY");d=1;}
	  if(l==17)  {sprintf(item3,"GRANARY");d=1;}
	  if(l==18)  {sprintf(item3,"GRANARY");d=1;}
	  if(l==20)  {sprintf(item3,"FARMERS GUILD");d=1;}
	  if(l==34)  {sprintf(item3,"MASON");d=1;}
	  if(l==21)  {sprintf(item3,"MINER");d=1;}
	  if(l==22)  {sprintf(item3,"MINER");d=1;}
	  if(l==5)   {sprintf(item3,"FOREST TRAPPER");d=1;}
	  if(l==6)   {sprintf(item3,"WOOD CUTTER");d=1;}
	  if(l==7)   {sprintf(item3,"WOOD CUTTER");d=1;}
	  if(l==9)   {sprintf(item3,"FISHERMAN");d=1;}
	  if(l==10)  {sprintf(item3,"FISHERMAN");d=1;}
	  if(l==11)  {sprintf(item3,"SHIP MAKER");d=1;}
	  if(l==12)  {sprintf(item3,"SHIP MAKER");d=1;}
	  if(l==38)  {sprintf(item3,"SAIL MAKER");d=1;}
	  if(l==39)  {sprintf(item3,"SHIP MASTERS GUILD");d=1;}
	  if(l==40)  {sprintf(item3,"FISHERMEN GUILD");d=1;}
	  if(l==41)  {sprintf(item3,"THIEVES GUILD");d=1;}
	  if(l==42)  {sprintf(item3,"MERCHANTS GUILD");d=1;}
	  if(l==43)  {sprintf(item3,"MAN-AT-ARMS GUILD");d=1;}
	  if(l==44)  {sprintf(item3,"MAN-AT-ARMS GUILD");d=1;}
	  if(l==45)  {sprintf(item3,"ASSASSINS GUILD");d=1;}
	  if(l==46)  {sprintf(item3,"WIZARDS GUILD");d=1;}
	  if(l==47)  {sprintf(item3,"MONEYLENDERS GUILD");d=1;}
	  if(l==48)  {sprintf(item3,"ARTISANS GUILD");d=1;}
	  if(l==49)  {sprintf(item3,"TEMPLE");d=1;}
	  if(l==50)  {sprintf(item3,"TEMPLE");d=1;}
	  if(l==51)  {sprintf(item3,"TEMPLE");d=1;}
	  if(l==57)  {sprintf(item3,"BANK");d=1;}
	  if(l==58)  {sprintf(item3,"BANK");d=1;}
	  if(l==63)  {sprintf(item3,"BUTCHER");d=1;}
	  if(l==64)  {sprintf(item3,"MERCANTILE EXCHANGE");d=1;}
	  if(l==65)  {sprintf(item3,"MERCANTILE EXCHANGE");d=1;}
	  if(l==66)  {sprintf(item3,"JAIL");d=1;}
	  if(l==67)  {sprintf(item3,"WELL");d=1;}
	  if(l==68)  {sprintf(item3,"WELL");d=1;}
	  if(l==69)  {sprintf(item3,"BARRACKS");d=1;}
	  if(l==70)  {sprintf(item3,"BARRACKS");d=1;}
	  if(l==71)  {sprintf(item3,"WAREHOUSE");d=1;}
	  if(l==72)  {sprintf(item3,"WAREHOUSE");d=1;}
	  if(l==73)  {sprintf(item3,"STABLE");d=1;}
	  if(l==74)  {sprintf(item3,"CARPENTER");d=1;}
	  if(l==75)  {sprintf(item3,"CARPENTER");d=1;}
	  if(l==76)  {sprintf(item3,"LOCKSMITH");d=1;}
	  if(l==77)  {sprintf(item3,"MUNICIPAL BUILDING");d=1;}
	  if(l==78)  {sprintf(item3,"MUNICIPAL BUILDING");d=1;}
	  if(l==79)  {sprintf(item3,"LEATHER WORKER");d=1;}
	  if(l==80)  {sprintf(item3,"WOOD CRAFTER");d=1;}
	  if(l==81)  {sprintf(item3,"WOOD CRAFTER");d=1;}
	  if(l==82)  {sprintf(item3,"GLASS WORKER");d=1;}
	  if(l==83)  {sprintf(item3,"GLASS WORKER");d=1;}
	  if(l==84)  {sprintf(item3,"ARTISAN");d=1;}
	  if(l==85)  {sprintf(item3,"LIBRARY");d=1;}
	  if(l==86)  {sprintf(item3,"LIBRARY");d=1;}
	  if(l==89)  {sprintf(item3,"STATUE");d=1;}
	  if(l==90)  {sprintf(item3,"PARK");d=1;}
	  if(l==91)  {sprintf(item3,"PARK");d=1;}
	  if(l==92)  {sprintf(item3,"PARK");d=1;}
	  if(l==93)  {sprintf(item3,"GRAVEYARD");d=1;}
	  if(l==94)  {sprintf(item3,"GRAVEYARD");d=1;}
	  if(l==95)  {sprintf(item3,"GRAVEYARD");d=1;}
	  if(l==96)  {sprintf(item3,"GRAVEYARD");d=1;}
	  if(l==97)  {sprintf(item3,"TAILOR");d=1;}
	  if(l==98)  {sprintf(item3,"TAILOR");d=1;}
	  if(l==99)  {sprintf(item3,"BAKER");d=1;}
	  if(l==100) {sprintf(item3,"BAKER");d=1;}
	  if(l==101) {sprintf(item3,"SHOEMAKER");d=1;}
	  if(l==108) {sprintf(item3,"STABLE");d=1;}
	  if(l==109) {sprintf(item3,"RESIDENCE  upper class");d=1;}
	  if(l==110) {sprintf(item3,"RESIDENCE  lower class");d=1;}
	  if(l==111) {sprintf(item3,"RESIDENCE middle class");d=1;}
	  if(l==112) {sprintf(item3,"RESIDENCE  upper class");d=1;}
	  if(l==113) {sprintf(item3,"RESIDENCE  lower class");d=1;}
	  if(l==114) {sprintf(item3,"RESIDENCE middle class");d=1;}
	  if((l>120)&&(l<=126)) {sprintf(item3,"CASTLE");d=1;}
	  if((l>126)&&(l<=132)) {sprintf(item3,"MARKET");d=1;}
	  if(l==133){sprintf(item3,"KEEP");d=1;}
	  if(l==134){sprintf(item3,"KEEP");d=1;}
	  if(l==136){sprintf(item3,"KEEP");d=1;}
	  if(l==137){sprintf(item3,"KEEP");d=1;}
	  if(l==135) {sprintf(item3,"WELL");d=1;}



      /*with names*/
	  if(l==4)   sprintf(item3,"EXOTIC BOOK SELLER");
	  if(l==13)  sprintf(item3,"SCULPTOR");
	  if(l==14)  sprintf(item3,"POTTER");
	  if(l==19)  sprintf(item3,"ROPE MAKER");
	  if(l==23)  sprintf(item3,"LAPIDARY");
	  if(l==24)  sprintf(item3,"LAPIDARY");
	  if(l==25)  sprintf(item3,"ARTISAN");
	  if(l==26)  sprintf(item3,"MAP MAKER");
	  if(l==27)  sprintf(item3,"MAP MAKER");
	  if(l==28)  sprintf(item3,"SCRIBE");
	  if(l==29)  sprintf(item3,"SCRIBE");
	  if(l==30)  sprintf(item3,"FURRIER");
	  if(l==31)  sprintf(item3,"FURRIER");
	  if(l==32)  sprintf(item3,"JEWELER");
	  if(l==33)  sprintf(item3,"JEWELER");
	  if(l==35)  sprintf(item3,"GENERAL STORE");
	  if(l==36)  sprintf(item3,"GENERAL STORE");
	  if(l==37)  sprintf(item3,"BAIT SHOP");
	  if(l==52)  sprintf(item3,"WEAPONSMITH");
	  if(l==53)  sprintf(item3,"WEAPONSMITH");
	  if(l==54)  sprintf(item3,"ARMORER");
	  if(l==55)  sprintf(item3,"ARMORER");
	  if(l==56)  sprintf(item3,"MONEY LENDER");
	  if(l==59)  sprintf(item3,"ALCHEMIST");
	  if(l==60)  sprintf(item3,"APOTHECARY");
	  if(l==61)  sprintf(item3,"TEXTILE SELLER");
	  if(l==62)  sprintf(item3,"TEXTILE SELLER");
	  if(l==87)  sprintf(item3,"BOOK SHOP");
	  if(l==88)  sprintf(item3,"BOOK SHOP");
	  if(l==102) sprintf(item3,"INN & TAVERN");
	  if(l==103) sprintf(item3,"RESTAURANT *");
	  if(l==104) sprintf(item3,"RESTAURANT **");
	  if(l==105) sprintf(item3,"RESTAURANT ***");
	  if(l==106) sprintf(item3,"RESTAURANT ****");
	  if(l==107) sprintf(item3,"RESTAURANT *****");
	  if(l==115) sprintf(item3,"BLACKSMITH");
	  if(l==116) sprintf(item3,"BLACKSMITH");
	  if(l==117) sprintf(item3,"INN");
	  if(l==118) sprintf(item3,"INN");
	  if(l==119) sprintf(item3,"TAVERN");
	  if(l==120) sprintf(item3,"TAVERN");
    } /*end if between 1 and 135*/
    if(d==1)  fprintf(fpmonst,"%-*.*s",4,26,item3);
    if(d==0){          /*create description by adjective and noun*/
       adj=(random(ADJECTIVES)+1);
       noun=(random(NOUNS)+1);
       fpdesc=fopen("tables\\city\\adj.tbl","r");
       for(f=1;f<=adj;f++){
		if(feof(fpdesc)) break;
		fgets(item,80,fpdesc);
		if(feof(fpdesc)) break;
       }
       fclose(fpdesc);


       fpdesc=fopen("tables\\city\\noun.tbl","r");
       for(f=1;f<=noun;f++){
		if(feof(fpdesc)) break;
		fgets(item2,80,fpdesc);
		if(feof(fpdesc)) break;
       }
       fclose(fpdesc);
       f=0;
      while(item[f]!='\n'){
	  f++;
	  }
       item[f]=' ';
       f=strlen(item2)-1;
       strncat(item,item2,f);

       fprintf(fpmonst,"%-*.*s %s",28,26,item3,item);
    }
       fprintf(fpmonst,"\n");
       fclose(fpmonst);
}


void writecitydesc(void)
{
int x,y;

fpmonst=fopen("text\\city.txt","a");
fprintf(fpmonst,"                           MAP LEGEND\n");
fprintf(fpmonst,"                          ============\n");
fprintf(fpmonst," X,Y                       TYPE                      NAME\n");
fprintf(fpmonst,
  "----------------------------------------------------------------------\n");
fclose(fpmonst);

  for(x=0;x<=40;x++){
    for(y=0;y<=25;y++){
       findtype(x,y);
    }
  }
}

void main()
{
int x,y;
int dotmatrix;

     if((fpmonst=fopen("data\\world.cfg","r"))!=NULL){;
	fscanf(fpmonst,"%d",&music);   /*1=music 0=no music*/
	fscanf(fpmonst,"%d",&dotmatrix);   /*0=laser 1=dotmatrix*/
	fclose(fpmonst);
       }
       else{ printf("No configuration found.  Run SETUP.EXE\n");
	     exit(0);
	    }


	vga256();
	wreadpalette(0,255,normpalette);
	wcls(0);
	randomize();
	if(music>0) soundset();  /*set music*/

	wsetpalette(0,255,normpalette);

	readdata();
	wcls(0);
	wtexttransparent(0);
	wtextcolor(255);
	wouttextxy(120,100,NULL,"Writing...");
  if(music>0) loadandplay("data\\m4");  /*play song if music on*/
	writecityinfo();
	writecitydesc();
	wsetpalette(0,255,normpalette);
	wcls(0);
    if(music>0) midiStopOutput();
    if(music>0) midiCloseDriver();

 execv("start",NULL);

exit(0);
}

