#include <stdio.h>
#include <stdlib.h>
#include <wgt4.h>
#include <dos.h>

static int MAP[41][26];
static int TMAP[41][26];

color tilepalette[256];
block tiles[29];
block keepit;
color ckeeppalette[256];



static int citysize;  /*1=hamlet 2=village 3=town 4=sm city 5=med city 6=lg city*/
static int castle;
static int keap;
static int market;
static int walls;
static int terrain;

static int total_bus=0;
static int total_gov=0;
static int total_temp=0;
static int total_res=0;
static int total_misc=0;
static int total_park=0;
static int total_all=0;



/***general*****/
static int scribe=0;
static int municipal=0;
static int artisan=0;
static int blacksmith=0;
static int inn=0;
static int inntavern=0;
static int tavern=0;
static int tailor=0;
static int baker=0;
static int shoemaker=0;
static int restaurant=0;
static int stable=0;
static int carpenter=0;
static int locksmith=0;
static int leatherworker=0;
static int woodcrafter=0;
static int glassworker=0;
static int sculptor=0;
static int mapmaker=0;
static int potter=0;
static int furrier=0;
static int jeweler=0;
static int mason=0;
static int generalstore=0;
static int temple=0;
static int weaponsmith=0;
static int armorer=0;
static int moneylender=0;
static int bank=0;
static int alchemist=0;
static int apothecary=0;
static int textileseller=0;
static int butcher=0;
static int mercantileexchange=0;
static int jail=0;
static int well=0;
static int statue=0;
static int resident=0;
static int barracks=0;
static int warehouse=0;
static int library=0;
static int bookseller=0;
static int park=0;
static int graveyard=0;

/*PLAINS*/
static int dairy=0;
static int grainery=0;
static int ropemaker=0;
static int farmersguild=0;

/*MOUNTAINS*/
static int miner=0;
static int lapidary=0;
static int mountaintrapper=0;
static int quary=0;
static int minersguild=0;

/*DESERT*/
static int exoticanimalseller=0;

/*FOREST*/
static int foresttrapper=0;
static int woodcutter=0;
static int forestersguild=0;

/*COASTAL*/
static int fisherman=0;
static int shipmaker=0;
static int baitseller=0;
static int sailmaker=0;
static int shipmastersguild=0;
static int fishermansguild=0;

/*GUILDS*/
static int thievesguild=0;
static int merchantsguild=0;
static int manatarmsguild=0;
static int assasinsguild=0;
static int wizardsguild=0;
static int moneylendersguild=0;
static int artisansguild=0;


int TOTALCOUNT=25;
int countln;
float lineplace;

FILE *fp;



/***********READ DATA***************/
void readcitydata(void)
{
int x,y;

	fp=fopen("temp\\city.tmp","r");

	fscanf(fp,"%d",&citysize);
	fscanf(fp,"%d",&terrain);
	fscanf(fp,"%d",&castle);
	fscanf(fp,"%d",&keap);
	fscanf(fp,"%d",&market);
	fscanf(fp,"%d",&walls);

	fscanf(fp,"%d",&total_bus);
	fscanf(fp,"%d",&total_gov);
	fscanf(fp,"%d",&total_temp);
	fscanf(fp,"%d",&total_res);
	fscanf(fp,"%d",&total_misc);
	fscanf(fp,"%d",&total_park);
	fscanf(fp,"%d",&total_all);

	fscanf(fp,"%d",&scribe);
	fscanf(fp,"%d",&municipal);
	fscanf(fp,"%d",&artisan);
	fscanf(fp,"%d",&blacksmith);
	fscanf(fp,"%d",&inn);
	fscanf(fp,"%d",&inntavern);
	fscanf(fp,"%d",&tavern);
	fscanf(fp,"%d",&tailor);
	fscanf(fp,"%d",&baker);
	fscanf(fp,"%d",&shoemaker);
	fscanf(fp,"%d",&restaurant);
	fscanf(fp,"%d",&stable);
	fscanf(fp,"%d",&carpenter);
	fscanf(fp,"%d",&locksmith);
	fscanf(fp,"%d",&leatherworker);
	fscanf(fp,"%d",&woodcrafter);
	fscanf(fp,"%d",&glassworker);
	fscanf(fp,"%d",&sculptor);
	fscanf(fp,"%d",&mapmaker);
	fscanf(fp,"%d",&potter);
	fscanf(fp,"%d",&furrier);
	fscanf(fp,"%d",&jeweler);
	fscanf(fp,"%d",&mason);
	fscanf(fp,"%d",&generalstore);
	fscanf(fp,"%d",&temple);
	fscanf(fp,"%d",&weaponsmith);
	fscanf(fp,"%d",&armorer);
	fscanf(fp,"%d",&moneylender);
	fscanf(fp,"%d",&bank);
	fscanf(fp,"%d",&alchemist);
	fscanf(fp,"%d",&apothecary);
	fscanf(fp,"%d",&textileseller);
	fscanf(fp,"%d",&butcher);
	fscanf(fp,"%d",&mercantileexchange);
	fscanf(fp,"%d",&jail);
	fscanf(fp,"%d",&well);
	fscanf(fp,"%d",&statue);
	fscanf(fp,"%d",&resident);
	fscanf(fp,"%d",&barracks);
	fscanf(fp,"%d",&warehouse);
	fscanf(fp,"%d",&library);
	fscanf(fp,"%d",&bookseller);
	fscanf(fp,"%d",&park);
	fscanf(fp,"%d",&graveyard);

	fscanf(fp,"%d",&dairy);
	fscanf(fp,"%d",&grainery);
	fscanf(fp,"%d",&ropemaker);
	fscanf(fp,"%d",&farmersguild);

	fscanf(fp,"%d",&miner);
	fscanf(fp,"%d",&lapidary);
	fscanf(fp,"%d",&mountaintrapper);
	fscanf(fp,"%d",&quary);
	fscanf(fp,"%d",&minersguild);

	fscanf(fp,"%d",&exoticanimalseller);

	fscanf(fp,"%d",&foresttrapper);
	fscanf(fp,"%d",&woodcutter);
	fscanf(fp,"%d",&forestersguild);

	fscanf(fp,"%d",&fisherman);
	fscanf(fp,"%d",&shipmaker);
	fscanf(fp,"%d",&baitseller);
	fscanf(fp,"%d",&sailmaker);
	fscanf(fp,"%d",&shipmastersguild);
	fscanf(fp,"%d",&fishermansguild);

	fscanf(fp,"%d",&thievesguild);
	fscanf(fp,"%d",&merchantsguild);
	fscanf(fp,"%d",&manatarmsguild);
	fscanf(fp,"%d",&assasinsguild);
	fscanf(fp,"%d",&wizardsguild);
	fscanf(fp,"%d",&moneylendersguild);
	fscanf(fp,"%d",&artisansguild);

	fclose(fp);
			    /*read array*/
	fp=fopen("temp\\citym.tmp","rb");
	  for(x=0;x<=40;x++){
	    for(y=0;y<=25;y++){
	       fread(&MAP[x][y],sizeof(int),1,fp);
	    }
	  }
	fclose(fp);               /*initialize temp map*/

}


/*change generic types to actual tile numbers*/
void changedata(void)
{
/*color 20=city ground*/
/*color 40=outside city*/
/*color 30=roads*/
/*color 50=castle*/
/*color 70=market*/
/*color 80=keep*/
/*color 60=walls*/
/*color 13=business*/
/*color 24=government*/
/*color 35=temple*/
/*color 46=residential*/
/*color 57=misc*/
/*color 68=park*/

int tile,rr,rrr;
int x,y,r,check;
int cast,mark,kea;

cast=castle;
mark=market;
kea=keap;

wcls(0);
  wtextcolor(15);
  wouttextxy(86,80,NULL," Creating Data...");
  wouttextxy(52,115,NULL,"   0%");
  wouttextxy(210,115,NULL,"100%");
  wsetcolor(55);
  wrectangle(101,111,203,121);


rr=0; /*random variable to pick from*/
rrr=0; /*secondary random variable to pick from*/


  for(y=1;y<=25;y++){
     for(x=1;x<=40;x++){
		countln=y;
		if (countln<=0) countln=1;
		lineplace=((float)countln/(float)TOTALCOUNT);
		lineplace=(lineplace*100);

		if(lineplace<=0) lineplace=1;
		  wsetcolor(70);
		wbar(102,112,(102+(int)lineplace),120);
       check=0;   /*reset tile check*/
       tile=MAP[x][y];
      /*	fp=fopen("temp\\test.tmp","a");
	fprintf(fp,"x=%d y=%d val=%d\n",x,y,tile);
	fclose(fp); */
       if((tile==50)&&(cast!=0)){
	  TMAP[x][y]=121;
	  TMAP[x+1][y]=122;
	  TMAP[x+2][y]=123;
	  TMAP[x][y+1]=124;
	  TMAP[x+1][y+1]=125;
	  TMAP[x+2][y+1]=126;
	  cast=0;
	   /*CASTLE*/
       } /*end castle*/

       if((tile==70)&&(mark!=0)){
	   /*MARKET*/
	   TMAP[x][y]=127;
	   TMAP[x+1][y]=128;
	   TMAP[x+2][y]=129;
	   TMAP[x][y+1]=130;
	   TMAP[x+1][y+1]=131;
	   TMAP[x+2][y+1]=132;
	   mark=0;
       } /*end market*/

       if((tile==80)&&(kea!=0)){
	   /*KEEP*/
	   TMAP[x][y]=133;
	   TMAP[x+1][y]=134;
	   TMAP[x][y+1]=136;
	   TMAP[x+1][y+1]=137;
	   kea=0;
       } /*end keep*/

       if(tile==60){
	   /*WALLS*/
	      r=0;
	      if((MAP[x][y-1]==60)&&(MAP[x][y+1]==60)) r=143; /*2*/
	      if((MAP[x-1][y]==60)&&(MAP[x+1][y]==60)) r=144; /*2*/
	      if((MAP[x+1][y]==60)&&(MAP[x][y+1]==60)) r=149; /*2*/
	      if((MAP[x-1][y]==60)&&(MAP[x][y+1]==60)) r=150; /*2*/
	      if((MAP[x-1][y]==60)&&(MAP[x][y-1]==60)) r=151; /*2*/
	      if((MAP[x][y-1]==60)&&(MAP[x+1][y]==60)) r=152; /*2*/
	      if((MAP[x-1][y-1]==60)&&(MAP[x+1][y]==60)) r=159; /*2*/
	      if((MAP[x+1][y-1]==60)&&(MAP[x-1][y-1]==60)) r=160; /*2*/
	      if((MAP[x+1][y-1]==60)&&(MAP[x+1][y+1]==60)) r=161; /*2*/
	      if((MAP[x-1][y+1]==60)&&(MAP[x+1][y+1]==60)) r=162; /*2*/
	      if((MAP[x-1][y-1]==60)&&(MAP[x-1][y+1]==60))  r=163; /*2*/
	      if((MAP[x-1][y-1]==60)&&(MAP[x][y+1]==60)&&
		 (MAP[x][y-1]!=60)) r=145; /*2*/
	      if((MAP[x+1][y-1]==60)&&(MAP[x][y+1]==60)&&
		 (MAP[x][y-1]!=60)) r=146; /*2*/
	      if((MAP[x][y-1]==60)&&(MAP[x-1][y+1]==60)&&
		 (MAP[x][y+1]!=60)) r=147; /*2*/
	      if((MAP[x][y-1]==60)&&(MAP[x+1][y+1]==60)&&
		 (MAP[x][y+1]!=60)) r=148; /*2*/
	      if((MAP[x-1][y]==60)&&(MAP[x+1][y+1]==60)&&
		 (MAP[x+1][y]!=60)) r=153; /*2*/
	      if((MAP[x-1][y]==60)&&(MAP[x+1][y-1]==60)&&
		 (MAP[x+1][y]!=60)) r=154; /*2*/
	      if((MAP[x-1][y]==60)&&(MAP[x+1][y]==60)&&
		 (MAP[x][y+1]==60)&&(MAP[x][y-1]==60)) r=155; /*2*/
	      if((MAP[x+1][y+1]==60)&&(MAP[x-1][y-1]==60)&&
		 (MAP[x][y-1]!=60)&&(MAP[x][y+1]!=60)) r=156; /*2*/
	      if((MAP[x+1][y-1]==60)&&(MAP[x-1][y+1]==60)&&
		 (MAP[x-1][y]!=60)) r=157; /*2*/
	      if((MAP[x-1][y+1]==60)&&(MAP[x+1][y]==60)&&
		 (MAP[x-1][y]!=60)) r=158; /*2*/
	      if((MAP[x][y-1]==60)&&(MAP[x+1][y+1]==60)&&
		 (MAP[x-1][y+1]==60)) r=164; /*3*/
	      if((MAP[x-1][y-1]==60)&&(MAP[x+1][y-1]==60)&&
		 (MAP[x][y+1]==60)) r=165; /*3*/
	      if((MAP[x+1][y-1]==60)&&(MAP[x+1][y+1]==60)&&
		 (MAP[x-1][y]==60)) r=166; /*3*/
	      if((MAP[x-1][y-1]==60)&&(MAP[x-1][y+1]==60)&&
		 (MAP[x+1][y]==60)) r=167; /*4*/
	      if((MAP[x-1][y]==60)&&(MAP[x+1][y]==60)&&(MAP[x][y-1]==60)&&
		 (MAP[x][y+1]==60)) r=155; /*4*/
	      if((MAP[x-1][y-1]==60)&&(MAP[x-1][y+1]==60)&&(MAP[x+1][y-1]==60)&&
		 (MAP[x+1][y+1]==60)) r=168; /*4*/

       TMAP[x][y]=r;  /*assign new value of wall to new map*/
       } /*end walls*/

       if(tile==13){
       while(check==0){
	   /*BUSINESS*/
	   rr=(random(46)+1);
	   if((rr==1)&&(scribe>0)){        /*scribe 28 & 29*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=28;
		if(rrr==2) TMAP[x][y]=29;
		scribe=scribe-1;
		check=1;
	     }
	   if((rr==2)&&(artisan>0)){        /*artisan 84 & 25*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=84;
		if(rrr==2) TMAP[x][y]=25;
		artisan=artisan-1;
		check=1;
	     }
	   if((rr==3)&&(blacksmith>0)){     /*blacksmith 115 & 116*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=115;
		if(rrr==2) TMAP[x][y]=116;
		blacksmith=blacksmith-1;
		check=1;
	     }
	   if((rr==4)&&(inn>0)){            /*inn 117 & 118*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=117;
		if(rrr==2) TMAP[x][y]=118;
		inn=inn-1;
		check=1;
	     }
	   if((rr==5)&&(inntavern>0)){        /*inntavern 102*/
		 TMAP[x][y]=102;
		 inntavern=inntavern-1;
		 check=1;
	     }
	   if((rr==6)&&(tavern>0)){           /*tavern 119 & 120*/
		 rrr=(random(2)+1);
		 if(rrr==1) TMAP[x][y]=119;
		 if(rrr==2) TMAP[x][y]=120;
		 tavern=tavern-1;
		 check=1;
	     }
	   if((rr==7)&&(tailor>0)){           /*tailor 97 & 98*/
		 rrr=(random(2)+1);
		 if(rrr==1) TMAP[x][y]=97;
		 if(rrr==2) TMAP[x][y]=98;
		 tailor=tailor-1;
		 check=1;
	     }
	   if((rr==8)&&(baker>0)){            /*baker 99 & 100*/
		 rrr=(random(2)+1);
		 if(rrr==1) TMAP[x][y]=99;
		 if(rrr==2) TMAP[x][y]=100;
		 baker=baker-1;
		 check=1;
	     }
	   if((rr==9)&&(shoemaker>0)){        /*shoemaker 101*/
		 TMAP[x][y]=101;
		 shoemaker=shoemaker-1;
		 check=1;
	     }
	   if((rr==10)&&(restaurant>0)){    /*restaurant 103-107*/
		rrr=(random(5)+1);
		if(rrr==1) TMAP[x][y]=103;
		if(rrr==2) TMAP[x][y]=104;
		if(rrr==3) TMAP[x][y]=105;
		if(rrr==4) TMAP[x][y]=106;
		if(rrr==5) TMAP[x][y]=107;
		restaurant=restaurant-1;
		check=1;
	     }
	   if((rr==11)&&(stable>0)){        /*stable 108 & 73*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=108;
		if(rrr==2) TMAP[x][y]=73;
		stable=stable-1;
		check=1;
	     }
	   if((rr==12)&&(carpenter>0)){     /*carpenter 74 & 75*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=74;
		if(rrr==2) TMAP[x][y]=75;
		carpenter=carpenter-1;
		check=1;
	     }
	   if((rr==13)&&(locksmith>0)){     /*locksmith 76*/
		TMAP[x][y]=76;
		locksmith=locksmith-1;
		check=1;
	     }
	   if((rr==14)&&(leatherworker>0)){  /*leatherworker 79*/
		TMAP[x][y]=79;
		leatherworker=leatherworker-1;
		check=1;
	     }
	   if((rr==15)&&(woodcrafter>0)){    /*woodcrafter 80 & 81*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=80;
		if(rrr==2) TMAP[x][y]=81;
		woodcrafter=woodcrafter-1;
		check=1;
	     }
	   if((rr==16)&&(glassworker>0)){    /*glassworker 82 & 83*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=82;
		if(rrr==2) TMAP[x][y]=83;
		glassworker=glassworker-1;
		check=1;
	     }
	   if((rr==17)&&(sculptor>0)){        /*sculptor 13*/
		TMAP[x][y]=13;
		sculptor=sculptor-1;
		check=1;
	     }
	   if((rr==18)&&(mapmaker>0)){        /*mapmaker 26 & 27*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=26;
		if(rrr==2) TMAP[x][y]=27;
		mapmaker=mapmaker-1;
		check=1;
	     }
	   if((rr==19)&&(potter>0)){        /*potter 14*/
		TMAP[x][y]=14;
		potter=potter-1;
		check=1;
	     }
	   if((rr==20)&&(furrier>0)){       /*furrier 30 & 31*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=30;
		if(rrr==2) TMAP[x][y]=31;
		furrier=furrier-1;
		check=1;
	     }
	   if((rr==21)&&(jeweler>0)){       /*jeweler 32 & 33*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=32;
		if(rrr==2) TMAP[x][y]=33;
		jeweler=jeweler-1;
		check=1;
	     }
	   if((rr==22)&&(mason>0)){          /*mason 34*/
		TMAP[x][y]=34;
		mason=mason-1;
		check=1;
	     }
	   if((rr==23)&&(generalstore>0)){    /*generalstore 35 & 36*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=35;
		if(rrr==2) TMAP[x][y]=36;
		generalstore=generalstore-1;
		check=1;
	     }
	   if((rr==24)&&(weaponsmith>0)){     /*weaponsmith 52 & 53*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=52;
		if(rrr==2) TMAP[x][y]=53;
		weaponsmith=weaponsmith-1;
		check=1;
	     }
	   if((rr==25)&&(armorer>0)){          /*armorer 54 & 55*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=54;
		if(rrr==2) TMAP[x][y]=55;
		armorer=armorer-1;
		check=1;
	     }
	   if((rr==26)&&(moneylender>0)){      /*moneylender 56*/
		TMAP[x][y]=56;
		moneylender=moneylender-1;
		check=1;
	     }
	   if((rr==27)&&(alchemist>0)){       /*alchemist 59*/
		TMAP[x][y]=59;
		alchemist=alchemist-1;
		check=1;
	     }
	   if((rr==28)&&(apothecary>0)){      /*apothecary 60*/
		TMAP[x][y]=60;
		apothecary=apothecary-1;
		check=1;
	     }
	   if((rr==29)&&(textileseller>0)){   /*textileseller 61 & 62*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=61;
		if(rrr==2) TMAP[x][y]=62;
		textileseller=textileseller-1;
		check=1;
	     }
	   if((rr==30)&&(butcher>0)){        /*butcher 63*/
		TMAP[x][y]=63;
		butcher=butcher-1;
		check=1;
	     }
	   if((rr==31)&&(warehouse>0)){     /*warehouse 71 & 72*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=71;
		if(rrr==2) TMAP[x][y]=72;
		warehouse=warehouse-1;
		check=1;
	     }
	   if((rr==32)&&(bookseller>0)){      /*bookseller 87 & 88*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=87;
		if(rrr==2) TMAP[x][y]=88;
		bookseller=bookseller-1;
		check=1;
	     }
	   if((rr==33)&&(dairy>0)){          /*dairy 15 & 16*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=15;
		if(rrr==2) TMAP[x][y]=16;
		dairy=dairy-1;
		check=1;
	     }
	   if((rr==34)&&(grainery>0)){      /*grainery 17 & 18*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=17;
		if(rrr==2) TMAP[x][y]=18;
		grainery=grainery-1;
		check=1;
	     }
	   if((rr==35)&&(ropemaker>0)){     /*ropemaker 19*/
		TMAP[x][y]=19;
		ropemaker=ropemaker-1;
		check=1;
	     }
	   if((rr==36)&&(miner>0)){         /*miner 21 & 22*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=21;
		if(rrr==2) TMAP[x][y]=22;
		miner=miner-1;
		check=1;
	     }
	   if((rr==37)&&(lapidary>0)){       /*lapidary 23 & 24*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=23;
		if(rrr==2) TMAP[x][y]=24;
		lapidary=lapidary-1;
		check=1;
	     }
	   if((rr==38)&&(mountaintrapper>0)){ /*mountaintrapper 1*/
		TMAP[x][y]=1;
		mountaintrapper=mountaintrapper-1;
		check=1;
	     }
	   if((rr==39)&&(quary>0)){           /*quary 2*/
		TMAP[x][y]=2;
		quary=quary-1;
		check=1;
	     }
	   if((rr==40)&&(exoticanimalseller>0)){ /*exoticanimalseller 4*/
		TMAP[x][y]=4;
		exoticanimalseller=exoticanimalseller-1;
		check=1;
	     }
	   if((rr==41)&&(foresttrapper>0)){  /*foresttrapper 5*/
		TMAP[x][y]=5;
		foresttrapper=foresttrapper-1;
		check=1;
	     }
	   if((rr==42)&&(woodcutter>0)){   /*woodcutter 6 & 7*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=6;
		if(rrr==2) TMAP[x][y]=7;
		woodcutter=woodcutter-1;
		check=1;
	     }
	   if((rr==43)&&(fisherman>0)){   /*fisherman 9 & 10*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=9;
		if(rrr==2) TMAP[x][y]=10;
		fisherman=fisherman-1;
		check=1;
	     }
	   if((rr==44)&&(shipmaker>0)){   /*shipmaker 11 & 12*/
		rrr=(random(2)+1);
		if(rrr==1) TMAP[x][y]=11;
		if(rrr==2) TMAP[x][y]=12;
		shipmaker=shipmaker-1;
		check=1;
	     }
	   if((rr==45)&&(baitseller>0)){  /*baitseller 37*/
		TMAP[x][y]=37;
		baitseller=baitseller-1;
		check=1;
	     }
	   if((rr==46)&&(sailmaker>0)){    /*sailmaker 38*/
		TMAP[x][y]=38;
		sailmaker=sailmaker-1;
		check=1;
	     }
	 }/*end while*/
       } /*end if business*/

       if(tile==24){
	   while(check==0){
	   /*GOVERNMENT */
	   rr=(random(6)+1);
	     if((rr==1)&&(municipal>0)){     /*municipal 77 & 78*/
	       rrr=(random(2)+1);
	       if(rrr==1) TMAP[x][y]=77;
	       if(rrr==2) TMAP[x][y]=78;
	       municipal=municipal-1;
	       check=1;
	     }
	     if((rr==2)&&(jail>0)){          /*jail 66*/
	       TMAP[x][y]=66;
	       jail=jail-1;
	       check=1;
	     }
	     if((rr==3)&&(barracks>0)){      /*barracks 69 & 70*/
	       rrr=(random(2)+1);
	       if(rrr==1) TMAP[x][y]=69;
	       if(rrr==2) TMAP[x][y]=70;
	       barracks=barracks-1;
	       check=1;
	     }
	     if((rr==4)&&(mercantileexchange>0)){/*mercantileexchange 64 & 65*/
	       rrr=(random(2)+1);
	       if(rrr==1) TMAP[x][y]=64;
	       if(rrr==2) TMAP[x][y]=65;
	       mercantileexchange=mercantileexchange-1;
	       check=1;
	     }
	     if((rr==5)&&(bank>0)){         /*bank 57 & 58*/
	       rrr=(random(2)+1);
	       if(rrr==1) TMAP[x][y]=57;
	       if(rrr==2) TMAP[x][y]=58;
	       bank=bank-1;
	       check=1;
	     }
	     if((rr==6)&&(library>0)){     /*library 85 & 86*/
	       rrr=(random(2)+1);
	       if(rrr==1) TMAP[x][y]=85;
	       if(rrr==2) TMAP[x][y]=86;
	       library=library-1;
	       check=1;
	     }
	   }/*end while*/
       } /*end government*/

       if(tile==35){                 /*temple 49 & 50 & 51*/
	    /*TEMPLE*/
	    rrr=(random(3)+1);
	    if(rrr==1) TMAP[x][y]=49;
	    if(rrr==2) TMAP[x][y]=50;
	    if(rrr==3) TMAP[x][y]=51;
	    temple=temple-1;
       } /*end temple*/

       if(tile==46){                 /*residential 109-114*/
	   /*RESIDENTIAL*/
	   rrr=(random(6)+1);
	   if(rrr==1) TMAP[x][y]=109;
	   if(rrr==2) TMAP[x][y]=110;
	   if(rrr==3) TMAP[x][y]=111;
	   if(rrr==4) TMAP[x][y]=112;
	   if(rrr==5) TMAP[x][y]=113;
	   if(rrr==6) TMAP[x][y]=114;
	   resident=resident-1;
       } /*end residential*/

       if(tile==57){
	   /*MISC*/

	 while(check==0){
	   rr=(random(14)+1);
	    if((rr==1)&&(well>0)){      /*well 67 & 68 & 135*/
	      rrr=(random(3)+1);
	      if(rrr==1) TMAP[x][y]=67;
	      if(rrr==2) TMAP[x][y]=68;
	      if(rrr==3) TMAP[x][y]=135;
	      well=well-1;
	      check=1;
	    }
	    if((rr==2)&&(statue>0)){    /*statue 89*/
	      TMAP[x][y]=89;
	      statue=statue-1;
	      check=1;
	    }
	    if((rr==3)&&(farmersguild>0)){ /*farmersguild 20*/
	      TMAP[x][y]=20;
	      farmersguild=farmersguild-1;
	      check=1;
	    }
	    if((rr==4)&&(minersguild>0)){   /*minersguild 3*/
	      TMAP[x][y]=3;
	      minersguild=minersguild-1;
	      check=1;
	    }
	   if((rr==5)&&(forestersguild>0)){ /*forestersguild 8*/
	      TMAP[x][y]=8;
	      forestersguild=forestersguild-1;
	      check=1;
	   }
	   if((rr==6)&&(shipmastersguild>0)){ /*shipmastersguild 39*/
	      TMAP[x][y]=39;
	      shipmastersguild=shipmastersguild-1;
	      check=1;
	   }
	   if((rr==7)&&(fishermansguild>0)){ /*fishermansguild 40*/
	     TMAP[x][y]=40;
	     fishermansguild=fishermansguild-1;
	     check=1;
	   }
	   if((rr==8)&&(thievesguild>0)){ /*thievesguild 41*/
	     TMAP[x][y]=41;
	     thievesguild=thievesguild-1;
	     check=1;
	   }
	   if((rr==9)&&(merchantsguild>0)){ /*merchantsguild 42*/
	     TMAP[x][y]=42;
	     merchantsguild=merchantsguild-1;
	     check=1;
	   }
	   if((rr==10)&&(manatarmsguild>0)){ /*manatarmsguild 43 & 44*/
	     rrr=(random(2)+1);
	     if(rrr==1) TMAP[x][y]=43;
	     if(rrr==2) TMAP[x][y]=44;
	     manatarmsguild=manatarmsguild-1;
	     check=1;
	   }
	   if((rr==11)&&(assasinsguild>0)){ /*assasinsguild 45*/
	     TMAP[x][y]=45;
	     assasinsguild=assasinsguild-1;
	     check=1;
	   }
	   if((rr==12)&&(wizardsguild>0)){ /*wizardsguild 46*/
	     TMAP[x][y]=46;
	     wizardsguild=wizardsguild-1;
	     check=1;
	   }
	   if((rr==13)&&(moneylendersguild>0)){/*moneylendersguild 47*/
	     TMAP[x][y]=47;
	     moneylendersguild=moneylendersguild-1;
	     check=1;
	   }
	   if((rr==14)&&(artisansguild>0)){   /*artisansguild 48*/
	     TMAP[x][y]=48;
	     artisansguild=artisansguild-1;
	     check=1;
	   }
	 }/*end while*/
       } /*end misc*/

       if(tile==68){
	 while(check==0){
	  /*PARK*/
	  rr=(random(2)+1);
	  if((rr==1)&&(park>0)){        /*park 90-92*/
	    rrr=(random(3)+1);
	    if(rrr==1) TMAP[x][y]=90;
	    if(rrr==2) TMAP[x][y]=91;
	    if(rrr==3) TMAP[x][y]=92;
	    park=park-1;
	    check=1;
	  }
	  if((rr==2)&&(graveyard>0)){   /*graveyard 4*/
	    rrr=(random(4)+1);
	    if(rrr==1) TMAP[x][y]=93;
	    if(rrr==2) TMAP[x][y]=94;
	    if(rrr==3) TMAP[x][y]=95;
	    if(rrr==4) TMAP[x][y]=96;
	    graveyard=graveyard-1;
	    check=1;
	  }
	 } /*end while*/
       } /*end park*/
       if(tile==30){
	 rr=0;
	 rrr=138;
	 if(MAP[x][y-1]==30) rr++;
	 if(MAP[x+1][y]==30) rr++;
	 if(MAP[x][y+1]==30) rr++;
	 if(MAP[x-1][y]==30) rr++;
	 if(MAP[x][y-1]==30) rrr=139;
	 if(MAP[x+1][y]==30) rrr=140;
	 if(MAP[x][y+1]==30) rrr=141;
	 if(MAP[x-1][y]==30) rrr=142;

	 if(rr>1) rrr=138;
	 TMAP[x][y]=rrr;
	 /*ROADS*/
	 }
    } /*end for y*/
  } /*end for x*/
}





/***********SAVE DATA***************/
void savecitydata(void)
{
  int x,y;


			    /*write array*/
	fp=fopen("temp\\citym.tmp","wb");
	  for(x=0;x<=40;x++){
	    for(y=0;y<=25;y++){
	       fwrite(&TMAP[x][y],sizeof(int),1,fp);
	    }
	  }
	fclose(fp);
}



 /*  make the walls  */
int WALLS(int x,int y)
{
int r; /*number to return*/
int check; /*number at check location*/
	   /*color 60=walls*/
   r=0;						 /*number of intersections*/
   if((MAP[x][y-1]==60)&&(MAP[x][y+1]==60)) r=1; /*2*/
   if((MAP[x-1][y]==60)&&(MAP[x+1][y]==60)) r=2; /*2*/
   if((MAP[x+1][y]==60)&&(MAP[x][y+1]==60)) r=7; /*2*/
   if((MAP[x-1][y]==60)&&(MAP[x][y+1]==60)) r=8; /*2*/
   if((MAP[x-1][y]==60)&&(MAP[x][y-1]==60)) r=9; /*2*/
   if((MAP[x][y-1]==60)&&(MAP[x+1][y]==60)) r=10; /*2*/
   if((MAP[x-1][y-1]==60)&&(MAP[x+1][y-1]==60)) r=20; /*2*/
   if((MAP[x+1][y-1]==60)&&(MAP[x+1][y+1]==60)) r=21; /*2*/
   if((MAP[x-1][y+1]==60)&&(MAP[x+1][y+1]==60)) r=22; /*2*/
   if((MAP[x-1][y-1]==60)&&(MAP[x-1][y+1]==60)) r=23; /*2*/
   if((MAP[x-1][y-1]==60)&&(MAP[x][y+1]==60)&&
	(MAP[x][y-1]!=60)) r=3; /*2*/
   if((MAP[x+1][y-1]==60)&&(MAP[x][y+1]==60)&&
	(MAP[x][y-1]!=60)) r=4; /*2*/
   if((MAP[x][y-1]==60)&&(MAP[x-1][y+1]==60)&&
	(MAP[x][y+1]!=60)) r=5; /*2*/
   if((MAP[x][y-1]==60)&&(MAP[x+1][y+1]==60)&&
	(MAP[x][y+1]!=60)) r=6; /*2*/
   if((MAP[x-1][y]==60)&&(MAP[x+1][y+1]==60)&&
	(MAP[x+1][y]!=60)) r=11; /*2*/
   if((MAP[x-1][y]==60)&&(MAP[x+1][y-1]==60)&&
       (MAP[x+1][y]!=60)) r=12; /*2*/
   if((MAP[x-1][y-1]==60)&&(MAP[x+1][y+1]==60)&&
	(MAP[x][y+1]!=60)&&(MAP[x][y-1]!=60)) r=14; /*2*/
   if((MAP[x+1][y-1]==60)&&(MAP[x-1][y+1]==60)&&
	(MAP[x][y-1]!=60)&&(MAP[x][y+1]!=60)) r=15; /*2*/
   if((MAP[x+1][y]==60)&&(MAP[x-1][y+1]==60)&&
	(MAP[x-1][y]!=60)) r=16; /*2*/
   if((MAP[x-1][y-1]==60)&&(MAP[x+1][y]==60)&&
	(MAP[x-1][y]!=60)) r=19; /*2*/
   if((MAP[x][y-1]==60)&&(MAP[x-1][y+1]==60)&&
	(MAP[x+1][y+1]==60)) r=24; /*3*/
   if((MAP[x-1][y-1]==60)&&(MAP[x+1][y-1]==60)&&
	(MAP[x][y+1]==60)) r=25; /*3*/
   if((MAP[x-1][y]==60)&&(MAP[x+1][y-1]==60)&&
	(MAP[x+1][y+1]==60)) r=26; /*3*/
   if((MAP[x-1][y+1]==60)&&(MAP[x-1][y-1]==60)&&
	(MAP[x+1][y]==60)) r=27; /*3*/
   if((MAP[x-1][y-1]==60)&&(MAP[x+1][y-1]==60)&&
	(MAP[x-1][y+1]==60)&&(MAP[x+1][y+1]==60)) r=28; /*4*/
   if((MAP[x-1][y]==60)&&(MAP[x+1][y]==60)&&(MAP[x][y-1]==60)&&
	(MAP[x][y+1]==60)) r=13; /*4*/

return r; /*return tile value for mini walls*/
}

void placepixels(int x, int xsize, int y, int ysize, int colors)
{
  int xp,yp;

	wsetcolor(colors);
	for(xp=x;xp<=(x+xsize-1);xp++){
	  for(yp=y;yp<=(y+ysize-1);yp++){
		wputpixel(xp,yp);
	  }
	}
}


int showmini(void)
{
int stx=80; /*starting x coordinate*/
int sty=50; /*starting y coordinate*/
int x,y;
int mpx, mpy;
int place; /*color at MAP[x][y]*/
int sp;    /*sprite number*/
int colr;  /*color of pixels*/
int tile; /*tile color*/
int kep; /*keep?  1=redo 2=keep 3=quit*/
int br; /*break*/

		     /*buildings are color numbers*/
		     /*mini tiles are 4x4*/
/*color 20=city ground*/
/*color 40=outside city*/
/*color 30=roads*/
/*color 50=castle*/
/*color 70=market*/
/*color 80=keep*/
/*color 60=walls*/
/*color 13=business*/
/*color 24=government*/
/*color 35=temple*/
/*color 46=residential*/
/*color 57=misc*/
/*color 68=park*/

kep=0;
br=0;
	mpx=stx; /*reset x and y start*/
	mpy=sty;
	wputblock(0,0,keepit,1);    /*place background*/

	for(x=0;x<=40;x++){
	  mpx=mpx+4;
	  mpy=sty;
	  for(y=0;y<=25;y++){
		   tile=MAP[x][y];
			  /*roads*/
		   if(tile==30){
			colr=111;
			placepixels(mpx,4,mpy,4,colr); /*x,x4,y,x4,color*/
			}
			  /*castle*/
		   if(tile==50){
			colr=145;
			placepixels(mpx,4,mpy,4,colr);
			}
			  /*market*/
		   if(tile==70){
			colr=78;
			placepixels(mpx,4,mpy,4,colr);
			}
			  /*keep*/
		   if(tile==80){
			colr=56;
			placepixels(mpx,4,mpy,4,colr);
			}
			  /*business*/
		   if(tile==13){
			colr=35;
			placepixels(mpx,4,mpy,4,colr);
			}
			  /*government*/
		   if(tile==24){
			colr=214;
			placepixels(mpx+1,2,mpy+1,2,colr);
			}
			  /*temple*/
		   if(tile==35){
			colr=15;
			placepixels(mpx+1,2,mpy+1,2,colr);
			}
			  /*residential*/
		   if(tile==46){
			colr=26;
			placepixels(mpx+1,2,mpy+1,2,colr);
			}
			  /*misc*/
		   if(tile==57){
			colr=31;
			placepixels(mpx+1,2,mpy+1,2,colr);
			}
			  /*park*/
		   if(tile==68){
			colr=50;
			placepixels(mpx,4,mpy,4,colr);
			}

			  /*walls*/
		   if(tile==60){
			sp=WALLS(x,y);

			wputblock(mpx,mpy,tiles[sp],1);
			}

		mpy=mpy+4;
	  } /*end y for loop*/
	} /*end x for loop*/

  /*yes or no?*/

	mon();
	br=0;
	 while(br==0){
		if(but==1){
			noclick();
			if((mx>85)&&(my>176)&&(mx<117)&&(my<186)){
				kep=1;   /*REDO*/
				br=1;
				}
			if((mx>136)&&(my>176)&&(mx<169)&&(my<186)){
				 kep=2;  /*KEEP*/
				 br=1;
				 }
			if((mx>188)&&(my>176)&&(mx<220)&&(my<186)){
				 kep=3;  /*QUIT*/
				 br=1;
				 }
		}

	 }
moff();

return kep;
}




void main(void)
{
int keepcity;
int x,y;
/*color 20=city ground*/
/*color 40=outside city*/
/*color 30=roads*/
/*color 50=castle*/
/*color 70=market*/
/*color 80=keep*/
/*color 60=walls*/
/*color 13=business*/
/*color 24=government*/
/*color 35=temple*/
/*color 46=residential*/
/*color 57=misc*/
/*color 68=park*/

randomize();
		       /*initialize map arrays*/
	  for(x=0;x<=40;x++){
	    for(y=0;y<=25;y++){
	       MAP[x][y]=0;
	       TMAP[x][y]=0;
	    }
	  }
keepcity=0;
vga256();
	minit();
	setlib("graphics\\citymini.lib");
	setpassword(" ");
	wloadsprites(tilepalette,"cminispr.spr",tiles,0,28);
	keepit=wloadpcx256("ckeep.pcx",ckeeppalette);
wsetpalette(0,255,ckeeppalette);

wcls(0);
readcitydata();     /*load data*/
keepcity=showmini();

if(keepcity==2) changedata();
savecitydata();
mdeinit();
wfreeblock(keepit);
wfreesprites(tiles,0,28);
if(keepcity==1) execv("citygen",NULL);
if(keepcity==2) execv("makctymp",NULL);
if(keepcity==3) execv("start",NULL);
exit(0);
}

