#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <wgt4.h>
#include <io.h>
#include <dspi.h>
#include <alloc.h>

#ifdef __DPMI32__
	#define  CONFIG   "MIDI32.CFG"
	#define  DRV      "32BIT"
#elif defined(__DPMI16__)
	#define  CONFIG   "MIDI16.CFG"
	#define  DRV      "16BIT"
#else
	#define  CONFIG   "MIDI.CFG"
	#define  DRV      "DRVR"
#endif


FILE *fpie;

block menub;
block titlescreen;
color menupalette[256];

int music;
int citysize;
int terrain;
int market;
int castle;
int keap;
int walls;


  struct time time1, time2;

LPBYTE GetConfigString (void) {
	FILE *fp;
	DWORD dwLen;
	LPBYTE file;


	chdir("DRVR");
	fp = fopen ("MIDI.CFG", "rb");
	if (fp == NULL) {
		return NULL;
	}
	chdir("..");
	dwLen = filelength(fileno(fp));
	file = (LPBYTE)farmalloc(dwLen + 1);
	fread (file, 1, (WORD)dwLen, fp);
	fclose (fp);
	return file;

}


void soundset()
{
	LPBYTE lpString;
	MIDICAPS caps;
	lpString = GetConfigString();
	if ( lpString == NULL ) {
		printf ("ERROR: Unable to load file %s\n", CONFIG);
		return;
	}
	chdir("DRVR");
	if ( midiLoadDriver((LPSTR)lpString) != MIDI_ERROR_NONE ) {
		printf ("ERROR: Unable to load driver %s\n", lpString);
		chdir ("..");
		return;
	}
	chdir ("..");
	midiSetDriverSpecific ( lpString + 13 );
	if ( midiDriverEntry() != MIDI_ERROR_NONE ) {
		printf ("ERROR: Cannot initialize driver\n");
		return;
	}
	midiGetDeviceCaps (&caps);
}




void loadandplay(char *perrysong)
{
	SMF_0 File;
	HPBYTE lpFile;

	lpFile = midiLoadSMF (perrysong, &File);
	if (lpFile == NULL) {
		midiCloseDriver();
		printf ("ERROR: Unable to load midi file");
		return;
	}
	if ( midiPlaySMF (lpFile, &File) != MIDI_ERROR_NONE ) {
		midiCloseDriver();
		printf ("ERROR: Unable to play MIDI file\n");
		return;
	}
}



int menus(void)
{
int change,stopp,quitt;
stopp=0;
quitt=0;
change=0;

  wcls(0);
	wsetpalette(0,255,menupalette);
	wputblock(0,0,menub,0);
		/*place text*/
		wtexttransparent(0);
		wtextcolor(15);

		if(citysize==1) wouttextxy(130,29,NULL,"Hamlet");
		if(citysize==2) wouttextxy(130,29,NULL,"Village");
		if(citysize==3) wouttextxy(130,29,NULL,"Town");
		if(citysize==4) wouttextxy(130,29,NULL,"Sml. City");
		if(citysize==5) wouttextxy(130,29,NULL,"Med. City");
		if(citysize==6) wouttextxy(130,29,NULL,"Lrg. City");

		if(terrain==1) wouttextxy(130,45,NULL,"Forest");
		if(terrain==2) wouttextxy(130,45,NULL,"Mountains");
		if(terrain==3) wouttextxy(130,45,NULL,"Desert");
		if(terrain==4) wouttextxy(130,45,NULL,"Plains");
		if(terrain==5) wouttextxy(130,45,NULL,"Coastal");

		if(market==1) wouttextxy(130,61,NULL,"Yes");
		if(market==0) wouttextxy(130,61,NULL,"None");

		if(castle==1) wouttextxy(130,77,NULL,"Yes");
		if(castle==0) wouttextxy(130,77,NULL,"None");

		if(keap==1) wouttextxy(130,92,NULL,"Yes");
		if(keap==0) wouttextxy(130,92,NULL,"None");

		if(walls==1) wouttextxy(130,108,NULL,"Yes");
		if(walls==0) wouttextxy(130,108,NULL,"None");

 /*get user input*/
mon();      /*turn mouse on*/
   while(stopp==0){
     if(but==1){
			moff();
			change=0;
			noclick();
			if((mx>238)&&(mx<293)&&(my>26)&&(my<37)){
					  citysize=citysize+1;/*citysize*/
					  if(citysize>6) citysize=1;
					  if(citysize<3) market=0;
					  if(citysize<4) castle=0;
					  if(citysize<3) keap=0;
					  if(citysize<4) walls=0;
					  change=1;
							}
			if((mx>238)&&(mx<293)&&(my>42)&&(my<52)){
					  terrain=terrain+1;/*terrain*/
					  if(terrain>5) terrain=1;
					  change=1;
							 }
			if((mx>238)&&(mx<293)&&(my>58)&&(my<68)){
					  if(market==0) market=1;/*market*/
					  else market=0;
					  if(citysize<3) market=0;
					  change=1;
							 }
			if((mx>238)&&(mx<293)&&(my>74)&&(my<84)){
					  if(castle==0) castle=1;/*castle*/
					  else castle=0;
					  if(citysize<4) castle=0;
					  change=1;
							 }
			if((mx>238)&&(mx<293)&&(my>89)&&(my<100)){
					  if(keap==0) keap=1;/*keep*/
					  else keap=0;
					  if(citysize<3) keap=0;
					  change=1;
							 }
			if((mx>238)&&(mx<293)&&(my>105)&&(my<118)){
					  if(walls==0) walls=1;/*walls*/
					  else walls=0;
					  if(citysize<4) walls=0;
					  change=1;
							 }
			if((mx>103)&&(mx<146)&&(my>167)&&(my<180)){
					  stopp=1;/*done*/
					  quitt=0;
							 }
			if((mx>152)&&(mx<197)&&(my>168)&&(my<179)){
					  stopp=1;/*quit*/
					  quitt=1;
							 }
       if(change==1){
		wputblock(0,0,menub,0);
		/*place text*/
		wtexttransparent(0);
		wtextcolor(15);

		if(citysize==1) wouttextxy(130,29,NULL,"Hamlet");
		if(citysize==2) wouttextxy(130,29,NULL,"Village");
		if(citysize==3) wouttextxy(130,29,NULL,"Town");
		if(citysize==4) wouttextxy(130,29,NULL,"Sml. City");
		if(citysize==5) wouttextxy(130,29,NULL,"Med. City");
		if(citysize==6) wouttextxy(130,29,NULL,"Lrg. City");

		if(terrain==1) wouttextxy(130,45,NULL,"Forest");
		if(terrain==2) wouttextxy(130,45,NULL,"Mountains");
		if(terrain==3) wouttextxy(130,45,NULL,"Desert");
		if(terrain==4) wouttextxy(130,45,NULL,"Plains");
		if(terrain==5) wouttextxy(130,45,NULL,"Coastal");

		if(market==1) wouttextxy(130,61,NULL,"Yes");
		if(market==0) wouttextxy(130,61,NULL,"None");

		if(castle==1) wouttextxy(130,77,NULL,"Yes");
		if(castle==0) wouttextxy(130,77,NULL,"None");

		if(keap==1) wouttextxy(130,92,NULL,"Yes");
		if(keap==0) wouttextxy(130,92,NULL,"None");

		if(walls==1) wouttextxy(130,108,NULL,"Yes");
		if(walls==0) wouttextxy(130,108,NULL,"None");
		change=0;
		}
       mon();
       } /*end if button hit*/
     } /*end while loop*/
moff();         /*turn mouse off*/
return quitt;
}


void  savedata()
{
	fpie=fopen("temp\\cdata.tmp","w");   /*read city data params*/
	fprintf(fpie,"%d\n",citysize);
	fprintf(fpie,"%d\n",terrain);
	fprintf(fpie,"%d\n",castle);
	fprintf(fpie,"%d\n",keap);
	fprintf(fpie,"%d\n",market);
	fprintf(fpie,"%d\n",walls);
	fclose(fpie);
}

void main()
{
int intstart;
  int dotmatrix;
  int stopp;

  stopp=0;
  citysize=1;
  terrain=1;
  market=0;
  castle=0;
  keap=0;
  walls=0;



     if((fpie=fopen("data\\world.cfg","r"))!=NULL){;
	fscanf(fpie,"%d",&music);   /*1=music 0=no music*/
	fscanf(fpie,"%d",&dotmatrix);   /*0=laser 1=dotmatrix*/
	fclose(fpie);
       }
       else{ printf("No configuration found.  Run SETUP.EXE\n");
	     exit(0);
	    }


	if(minit()<0){        /*initialize mouse*/
		printf("No mouse or mouse driver was found.\n");
		printf("This program will not run without a mouse\n");
		exit(0);
		}


  vga256();
  wcls(0);

	if(music>0) soundset();  /*set music*/



	setlib("graphics\\city.lib");
	setpassword(" ");
	/*setpassword("orcus");*/
	menub=wloadpcx256("menu.pcx",menupalette);



msetbounds(0,0,319,199);
msetxy(100,100);

  stopp=0;
  if(music>0) loadandplay("data\\m6");  /*play song if music on*/
  stopp=menus();

    if(music>0) midiStopOutput();
    if(music>0) midiCloseDriver();

    wfreeblock(menub);
    mdeinit();
   wcls(0);

if(stopp==1)    execv("start",NULL);
if(stopp==0) {
		savedata();
		execv("citygen",NULL);
		}

exit(0);

}


