




/********************************************************/
/*       Fantasy Dungeon Creator V2.1 by Perry Horner   */
/*************************1994***************************/

/* extern unsigned _stklen=16384; */


#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graphics.h>
#include <string.h>
#include "plib.h"
#include "printer.h"
#include "plib.glo"

extern FILE *fp;  /*  READFILE pointer */
extern FILE *wp; /*   WRITEFILE pointer  */
static long char *T[39][8][8];
static long int  MAP[64][21];
static char *DT[80];
static char *item[80];
static int level;
static long char *dn;
static int pron,dsk;
static int GraphDriver;
static int GraphMode;
static double AspectRatio;
static int MaxX, MaxY;
static int MaxColors;
static int ErrorCode;
static int sdunlevel,edunlevel;
static struct palettetype palette;
static int gprintf(int *xloc, int *yloc, char *fmt, ...);

/*** INITIALIZE TILE COMPATABILITY WITH TOP OF MAP TILES ****/
static int DATAtop1[21]={11,3,4,7,9,12,13,16,17,18,19,27,26,24,28,29,31,33,34,35,37};
static int DATAtop2[21]={11,3,4,7,9,12,13,16,17,18,19,27,26,24,28,29,31,33,34,35,37};
static int DATAtop3[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,38,99,99,99,99};
static int DATAtop4[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,38,99,99,99,99};
static int DATAtop5[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,38,99,99,99,99};
static int DATAtop6[21]={11,3,4,7,9,12,13,16,17,18,19,27,26,24,28,29,31,33,34,35,37};
static int DATAtop7[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,38,37,99,99,99};
static int DATAtop8[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,38,99,99,99,99};
static int DATAtop9[21]={11,3,4,7,9,12,13,16,17,18,19,27,26,24,28,29,31,33,34,35,99};
static int DATAtop10[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,37,38,99,99,99};
static int DATAtop11[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,38,99,99,99,99};
static int DATAtop12[21]={99,3,4,7,9,99,99,16,17,18,19,27,26,24,28,29,31,33,34,35,99};
static int DATAtop13[21]={99,3,4,7,9,99,99,16,17,18,19,27,26,24,28,29,31,33,34,35,99};
static int DATAtop14[21]={99,3,4,7,9,99,99,16,17,18,19,27,26,24,28,29,31,33,34,35,99};
static int DATAtop15[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,37,38,99,99,99};
static int DATAtop16[21]={11,3,4,7,9,12,13,16,17,18,19,27,26,24,28,29,31,33,34,35,99};
static int DATAtop17[21]={3,4,7,9,11,12,13,16,17,18,19,27,26,24,28,29,31,33,34,35,37};
static int DATAtop18[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,38,99,99,99,99};
static int DATAtop19[21]={8,5,6,1,10,2,14,15,20,21,22,23,25,30,32,36,38,99,99,99,99};
static int DATAtop20[21]={11,3,4,7,9,12,13,16,17,18,19,27,26,24,28,29,31,33,34,35,37};
static int DATAtop21[21]={11,3,4,7,9,12,13,16,17,18,19,27,26,24,28,29,31,33,34,35,37};
static int DATAtop22[21]={21,20,15,14,2,10,1,6,5,8,23,25,99,30,32,36,38,99,99,99,99};
static int DATAtop23[21]={21,20,15,14,2,10,1,6,5,8,23,25,99,30,32,36,38,99,99,99,99};
static int DATAtop24[21]={21,20,15,14,2,10,1,6,5,8,23,30,32,36,38,99,99,99,99,99,99};
static int DATAtop25[21]={18,17,16,13,12,9,7,4,3,11,24,28,29,31,33,34,35,99,99,99,99};
static int DATAtop26[21]={18,17,16,13,12,9,7,4,3,11,24,27,28,29,31,33,34,35,99,99,99};
static int DATAtop27[21]={18,17,16,13,12,9,7,4,3,11,24,26,28,29,31,33,34,35,99,99,99};

/******DATATOP for 28-38*************/
static int DATAtop28[21]={28,29,31,33,34,35,37,11,3,4,7,9,12,13,16,17,18,19,24,26,27};
static int DATAtop29[21]={28,29,31,33,34,35,37,11,3,4,7,9,12,13,16,17,18,19,24,26,27};
static int DATAtop30[21]={30,32,36,37,38,8,5,6,1,10,2,14,15,20,21,22,23,25,99,99,99};
static int DATAtop31[21]={31,28,29,33,35,34,37,11,3,4,7,9,12,13,16,17,18,19,24,26,27};
static int DATAtop32[21]={30,32,36,37,38,8,5,6,1,10,2,14,15,20,21,22,23,25,99,99,99};
static int DATAtop33[21]={28,29,31,33,34,35,37,11,3,4,7,9,12,13,16,17,18,19,24,26,27};
static int DATAtop34[21]={28,29,31,33,34,35,37,11,3,4,7,9,12,13,16,17,18,19,24,26,27};
static int DATAtop35[21]={30,32,36,37,38,8,5,6,1,10,2,14,15,20,21,22,23,25,99,99,99};
static int DATAtop36[21]={28,29,31,33,34,35,37,11,3,4,7,9,12,13,16,17,18,19,24,26,27};
static int DATAtop37[21]={3,4,9,16,17,18,19,24,26,27,28,29,31,33,34,35,37,32,30,99,99};
static int DATAtop38[21]={30,32,36,37,38,8,5,6,1,10,2,14,15,20,21,22,23,25,99,99,99};



/****INITIALIZE LEFT COMPATABILITY OF TILES ON MAP*****/

static int DATAleft1[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft2[21]={11,3,1,10,12,14,15,17,19,20,23,26,29,30,35,36,37,99,99,99,99};
static int DATAleft3[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft4[21]={11,3,1,10,12,14,15,17,19,20,23,26,29,30,35,36,37,99,99,99,99};
static int DATAleft5[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft6[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft7[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft8[21]={99,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft9[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft10[21]={11,3,1,10,12,14,15,17,19,20,23,26,24,25,29,30,35,36,37,99,99};
static int DATAleft11[21]={99,3,1,10,12,99,15,17,19,20,23,26,24,25,29,30,35,36,99,99,99};
static int DATAleft12[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft13[21]={99,3,1,10,99,99,15,17,19,20,23,26,24,25,99,30,35,36,99,99};
static int DATAleft14[21]={99,3,1,10,12,99,15,17,19,20,23,26,24,25,29,30,35,36,99,99,99};
static int DATAleft15[21]={11,3,1,10,12,14,15,17,19,20,23,26,24,25,29,30,35,36,37,99,99};
static int DATAleft16[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft17[21]={1,3,10,11,12,14,15,17,19,20,23,24,25,26,29,30,35,36,37,99,99};
static int DATAleft18[21]={11,3,1,10,12,14,15,17,19,20,23,24,25,26,29,30,35,36,37,99,99};
static int DATAleft19[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft20[21]={8,4,5,6,7,9,2,13,16,18,21,22,27,28,31,32,33,34,38,99,99};
static int DATAleft21[21]={11,3,1,10,12,14,15,17,19,20,23,24,25,26,29,30,35,36,37,99,99};
static int DATAleft22[21]={11,3,1,10,12,14,15,17,19,20,23,24,25,26,29,30,35,36,37,99,99};
static int DATAleft23[21]={27,22,21,18,16,13,2,9,7,6,5,4,8,28,31,32,33,34,38,99,99};
static int DATAleft24[21]={26,25,23,20,19,17,15,14,12,10,1,3,24,25,29,30,35,36,37,99,99};
static int DATAleft25[21]={26,25,23,99,19,17,99,14,12,10,1,3,24,25,29,30,35,36,37,99,99};
static int DATAleft26[21]={22,21,18,16,13,2,9,7,6,5,4,8,31,32,33,34,38,99,99,99,99};
static int DATAleft27[21]={26,25,24,23,20,19,17,15,14,12,10,1,3,11,29,30,35,36,37,99,99};

/****DATAleft 28-38 **********/
static int DATAleft28[21]={29,30,35,36,37,11,3,1,10,12,14,15,19,20,23,24,25,26,17,99,99};
static int DATAleft29[21]={31,32,33,34,37,38,8,4,5,6,7,9,2,13,16,18,21,22,27,99,99};
static int DATAleft30[21]={29,35,36,37,11,3,1,10,12,14,15,17,19,20,23,24,25,26,99,99,99};
static int DATAleft31[21]={28,31,32,33,34,37,38,8,4,5,6,7,9,2,13,16,18,21,22,27,99};
static int DATAleft32[21]={28,31,32,33,34,37,38,8,4,5,6,7,9,2,13,16,18,21,22,27,99};
static int DATAleft33[21]={28,31,32,33,34,37,38,8,4,5,6,7,9,2,13,16,18,21,22,27,99};
static int DATAleft34[21]={28,31,32,33,34,37,38,8,4,5,6,7,9,2,13,16,18,21,22,27,99};
static int DATAleft35[21]={29,30,99,36,37,99,3,1,10,99,99,15,17,19,20,23,24,25,26,99,99};
static int DATAleft36[21]={29,30,35,99,37,99,3,1,10,99,99,15,17,19,20,23,24,25,26,99,99};
static int DATAleft37[21]={28,29,30,31,32,35,36,37,11,3,1,9,10,23,24,15,17,19,20,25,26};
static int DATAleft38[21]={28,31,32,33,34,37,38,8,4,5,6,7,9,2,13,16,18,21,22,27,99};




static int DATAdum[21]={99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99};



static int size,room,var,check,dummy,max_room;
static long int i;
static int x,y,z,count,inc;
static int cx,cy;	/*coordinate x and coordinate y for MAP[][]  */
static int sel;
static int lev;







/*********************************************************************/
/*               START OF PROGRAM         main()                     */
/*********************************************************************/
void main()
{


	int nmap;
	char st[80];
	char flname[12]={"DLEV"};
	union REGS regs;
	union REGS regs2;
	char ml[3];
	InputAbsolute=AbortPrint=0;
	sdunlevel=1;
	edunlevel=1;
	max_room=1;

	pron=0;  /* printer off */
	dsk=0;   /* diskwrite off */
	initialize();
	if(GraphDriver==EGA||GraphDriver==EGALO||GraphDriver==VGA)
	title();
	closegraph();
	textcolor(LIGHTGREEN);
	textbackground(0);
	Cleartile();
	tileinit();

	clrscr();
	normvideo();
	textmode(3);
	room=1;
	regs.h.ch=0x20;
	regs.h.ah=1;
	int86(0x10,&regs,&regs);
	inquire_size();


	clrscr();

	edunlevel=1;
	for(nmap=1;nmap<=edunlevel;nmap++){
		room=1;
		strcpy(flname,"DLEV");
		fclose(wp);
		if(dsk==1) {
			     itoa(nmap,ml,10);
			     strcat(flname,ml);
			     strcat(flname,".MOD");
			     wp=fopen(flname,"w");

			     }
		randomize();
		Cleartile();
		tileinit();
		create_map();
		max_room=1;
		print_map();
		randomize();
		interior();
		sdunlevel++;
		room=1;
	}
	fclose(wp);
	closegraph();
	GraphDriver=DETECT;
	initgraph(&GraphMode,&GraphDriver,"");
	closegraph();
	clrscr();
	printf("If you have any questions or comments about this\n");
	printf("software,or would like to register please write:\n\n");
	printf("Perry Horner\n7040 W. Olive Ave Unit #38\n");
	printf("Peoria, AZ  85345\nUSA\n\n");
	printf("\n\nThis program was written in Borland Turbo C 2.00");
	printf("\nBorland is a registered trademark of Borland Intl. 1992");
	printf("\n\n\n             *=UNREGISTERED VERSION=*\n\n");




	exit(1);
}

int Pause(void)
{
	int c;
	c=0;
	for(;;){
	c=getch();
		if(c<56){
			if(c>48){
			return(c);
			}
		}
	}
}


tileinit()
{
/**********           TILE DEFINITION   ***************/
/******8********/

*T[8][1]=" /-DD-\\ ";
*T[8][2]="|      |";
*T[8][3]="|      |";
*T[8][4]="D      D";
*T[8][5]="D      D";
*T[8][6]="|      |";
*T[8][7]="|      |";
*T[8][8]=" \\-DD-/ ";

/*****11*******/

*T[11][1]=" /-||-\\ ";
*T[11][2]="|      |";
*T[11][3]="|      |";
*T[11][4]="|      |";
*T[11][5]="|      |";
*T[11][6]="|      |";
*T[11][7]="|      |";
*T[11][8]=" \\----/ ";

/******3********/

*T[3][1]="   ||   ";
*T[3][2]="  / /   ";
*T[3][3]="_/ /    ";
*T[3][4]="  /     ";
*T[3][5]="_/      ";
*T[3][6]="        ";
*T[3][7]="        ";
*T[3][8]="        ";

/******4********/

*T[4][1]="   ||   ";
*T[4][2]="   \\ \\  ";
*T[4][3]="    \\ \\_";
*T[4][4]="     \\  ";
*T[4][5]="      \\_";
*T[4][6]="        ";
*T[4][7]="        ";
*T[4][8]="        ";

/*******5********/

*T[5][1]="   ||   ";
*T[5][2]="   ||   ";
*T[5][3]="___||___";
*T[5][4]="        ";
*T[5][5]="___  ___";
*T[5][6]="   ||   ";
*T[5][7]="   ||   ";
*T[5][8]="   ||   ";

/*******6********/

*T[6][1]="        ";
*T[6][2]="        ";
*T[6][3]="________";
*T[6][4]="        ";
*T[6][5]="___  ___";
*T[6][6]="   ||   ";
*T[6][7]="   ||   ";
*T[6][8]="   ||   ";

/*******7********/
*T[7][1]="   ||   ";
*T[7][2]="   ||   ";
*T[7][3]="___||___";
*T[7][4]="        ";
*T[7][5]="________";
*T[7][6]="        ";
*T[7][7]="        ";
*T[7][8]="        ";

/*******1********/
*T[1][1]="        ";
*T[1][2]="        ";
*T[1][3]="_       ";
*T[1][4]=" \\      ";
*T[1][5]="_ \\     ";
*T[1][6]=" \\ \\    ";
*T[1][7]="  \\ \\   ";
*T[1][8]="   ||   ";

/*******9********/
*T[9][1]="        ";
*T[9][2]="        ";
*T[9][3]="________";
*T[9][4]="        ";
*T[9][5]="________";
*T[9][6]="        ";
*T[9][7]="        ";
*T[9][8]="        ";

/*******10*******/
*T[10][1]="   ||   ";
*T[10][2]="   ||   ";
*T[10][3]="   ||   ";
*T[10][4]="   ||   ";
*T[10][5]="   ||   ";
*T[10][6]="   ||   ";
*T[10][7]="   ||   ";
*T[10][8]="   ||   ";

/*******2*********/
*T[2][1]= "        ";
*T[2][2]= "        ";
*T[2][3]= "       _";
*T[2][4]= "      / ";
*T[2][5]= "     / _";
*T[2][6]= "    / / ";
*T[2][7]= "   / /  ";
*T[2][8]= "   ||   ";

/********12*******/
*T[12][1]=" /----\\ ";
*T[12][2]="|      |";
*T[12][3]="|      |";
*T[12][4]="D      |";
*T[12][5]="D      |";
*T[12][6]="|      |";
*T[12][7]="|      |";
*T[12][8]=" \\----/ ";

/*********13*******/
*T[13][1]=" /----\\ ";
*T[13][2]="|      |";
*T[13][3]="|      |";
*T[13][4]="|      D";
*T[13][5]="|      D";
*T[13][6]="|      |";
*T[13][7]="|      |";
*T[13][8]=" \\----/ ";

/*********14*********/
*T[14][1]=" /----\\ ";
*T[14][2]="|      |";
*T[14][3]="|      |";
*T[14][4]="|      |";
*T[14][5]="|      |";
*T[14][6]="|      |";
*T[14][7]="|      |";
*T[14][8]=" \\-DD-/ ";

/*********15*********/
*T[15][1]="   ||   ";
*T[15][2]="  / /   ";
*T[15][3]="  ||    ";
*T[15][4]="  ||    ";
*T[15][5]="  DD    ";
*T[15][6]="  \\ \\   ";
*T[15][7]="   \\ \\  ";
*T[15][8]="   / /  ";

/********16**********/
*T[16][1]="        ";
*T[16][2]="        ";
*T[16][3]="________";
*T[16][4]="    D   ";
*T[16][5]="____D___";
*T[16][6]="        ";
*T[16][7]="        ";
*T[16][8]="        ";

/*******17********/
for(x=1;x<=8;x++) {*T[17][x]="        ";}

/*******18********/
*T[18][1]="   ||   ";
*T[18][2]="   ||   ";
*T[18][3]="   ||___";
*T[18][4]="   |    ";
*T[18][5]="   |____";
*T[18][6]="        ";
*T[18][7]="        ";
*T[18][8]="        ";

/******19********/
*T[19][1]="   ||   ";
*T[19][2]="   ||   ";
*T[19][3]="___||   ";
*T[19][4]="    |   ";
*T[19][5]="____|   ";
*T[19][6]="        ";
*T[19][7]="        ";
*T[19][8]="        ";

/********20*******/
*T[20][1]="        ";
*T[20][2]="        ";
*T[20][3]="____    ";
*T[20][4]="    |   ";
*T[20][5]="___ |   ";
*T[20][6]="   ||   ";
*T[20][7]="   ||   ";
*T[20][8]="   ||   ";

/********21********/
*T[21][1]="        ";
*T[21][2]="        ";
*T[21][3]="    ____";
*T[21][4]="   |    ";
*T[21][5]="   | ___";
*T[21][6]="   ||   ";
*T[21][7]="   ||   ";
*T[21][8]="   ||   ";

/*********22*********/
*T[22][1]="   ||   ";
*T[22][2]="   ||   ";
*T[22][3]="   ||___";
*T[22][4]="   |    ";
*T[22][5]="   | ___";
*T[22][6]="   ||   ";
*T[22][7]="   ||   ";
*T[22][8]="   ||   ";

/*********23*********/
*T[23][1]="   ||   ";
*T[23][2]="   ||   ";
*T[23][3]="___||   ";
*T[23][4]="    |   ";
*T[23][5]="___ |   ";
*T[23][6]="   ||   ";
*T[23][7]="   ||   ";
*T[23][8]="   ||   ";

/********24*********/
*T[24][1]="   ||   ";
*T[24][2]="   ||   ";
*T[24][3]="   ||   ";
*T[24][4]="   ||   ";
*T[24][5]="   ==   ";
*T[24][6]="        ";
*T[24][7]="        ";
*T[24][8]="        ";

/********25*********/
*T[25][1]="        ";
*T[25][2]="        ";
*T[25][3]="        ";
*T[25][4]="   ==   ";
*T[25][5]="   ||   ";
*T[25][6]="   ||   ";
*T[25][7]="   ||   ";
*T[25][8]="   ||   ";

/********26*********/
*T[26][1]="        ";
*T[26][2]="        ";
*T[26][3]="_____   ";
*T[26][4]="     |  ";
*T[26][5]="_____|  ";
*T[26][6]="        ";
*T[26][7]="        ";
*T[26][8]="        ";

/*********27*********/
*T[27][1]="        ";
*T[27][2]="        ";
*T[27][3]="    ____";
*T[27][4]="   |    ";
*T[27][5]="   |____";
*T[27][6]="        ";
*T[27][7]="        ";
*T[27][8]="        ";

/********28*********/
*T[28][1]="  __    ";
*T[28][2]=" |  \\   ";
*T[28][3]=" |   \\__";
*T[28][4]=" |      ";
*T[28][5]=" |    __";
*T[28][6]=" |   /  ";
*T[28][7]=" |__/   ";
*T[28][8]="        ";

/********29*********/
*T[29][1]="     __ ";
*T[29][2]="    /  |";
*T[29][3]="___/   |";
*T[29][4]="       |";
*T[29][5]="___    |";
*T[29][6]="   \\   |";
*T[29][7]="    \\__|";
*T[29][8]="        ";

/********30*********/
*T[30][1]="   ||   ";
*T[30][2]="   ||   ";
*T[30][3]="  /  \\  ";
*T[30][4]=" /    \\ ";
*T[30][5]="|      |";
*T[30][6]=" \\    / ";
*T[30][7]="  \\  /  ";
*T[30][8]="   ||   ";

/********31*********/
*T[31][1]="        ";
*T[31][2]="  ____  ";
*T[31][3]="_/    \\_";
*T[31][4]="        ";
*T[31][5]="_      _";
*T[31][6]=" \\____/ ";
*T[31][7]="        ";
*T[31][8]="        ";

/********32********/
*T[32][1]="   ||   ";
*T[32][2]="  /  \\  ";
*T[32][3]="_|    |_";
*T[32][4]="        ";
*T[32][5]="_      _";
*T[32][6]=" |    | ";
*T[32][7]="  \\  /  ";
*T[32][8]="   ||   ";

/********33********/
*T[33][1]="        ";
*T[33][2]="  ____  ";
*T[33][3]="_/ __ \\_";
*T[33][4]="  /  \\  ";
*T[33][5]="_/    \\_";
*T[33][6]="        ";
*T[33][7]="        ";
*T[33][8]="        ";

/********34********/
*T[34][1]="        ";
*T[34][2]="        ";
*T[34][3]="_      _";
*T[34][4]=" \\    / ";
*T[34][5]="_ \\__/ _";
*T[34][6]=" \\____/ ";
*T[34][7]="        ";
*T[34][8]="        ";

/********35*********/
*T[35][1]="   ||   ";
*T[35][2]="  /  \\  ";
*T[35][3]=" /    \\ ";
*T[35][4]="|      |";
*T[35][5]="|______|";
*T[35][6]="        ";
*T[35][7]="        ";
*T[35][8]="        ";

/*********36*******/
*T[36][1]="        ";
*T[36][2]="        ";
*T[36][3]=" ______ ";
*T[36][4]="|      |";
*T[36][5]="|      |";
*T[36][6]=" \\    / ";
*T[36][7]="  \\  /  ";
*T[36][8]="   ||   ";

/********37********/
*T[37][1]="        ";
*T[37][2]="  ^^^   ";
*T[37][3]="W ^^^^^ ";
*T[37][4]="^A ^^^^ ";
*T[37][5]=" ^T^^^  ";
*T[37][6]=" ^ E^^  ";
*T[37][7]="  ^^R^^^";
*T[37][8]="   ^^^  ";

/*******38********/
*T[38][1]="   ||   ";
*T[38][2]="  /  \\  ";
*T[38][3]="_/    \\_";
*T[38][4]="        ";
*T[38][5]="_      _";
*T[38][6]=" \\    / ";
*T[38][7]="  \\  /  ";
*T[38][8]="   ||   ";

return;
}
Cleartile()
{

	int perry;
	int horner;
	for(perry=1;perry<=38;perry++){
		for(horner=1;horner<=8;horner++){
			*T[perry][horner]="        ";
			}
		}
return;
}

void secret( void )
{
	int rl;
	char *c;
	rl=0;
	c="S";
	rl=(random(20)+1);

	if(rl>=19){

		switch(i){

		case 	8:	{*((T[i][1][0])+3)=*c;
				 *((T[i][1][0])+4)=*c;
					break;
				}
		case 	11:	{*((T[i][1][0])+3)=*c;
				 *((T[i][1][0])+4)=*c;
					break;
				 }
		case	13:	{*((T[i][4][0])+7)=*c;
				 *((T[i][5][0])+7)=*c;
					break;
				}
		case	14:	{*((T[i][8][0])+3)=*c;
				 *((T[i][8][0])+4)=*c;
					break;
				}
		case	12:	{*((T[i][4][0]))=*c;
				 *((T[i][5][0]))=*c;
					break;
				 }
		default	:	break;
		}
	 }
 return;
}


initialize()
{
	int xasp,yasp;     /*** initialize graphics  ****/

	if(registerfarbgidriver(EGAVGA_driver_far)<0) exit(1);
	if(registerfarbgidriver(CGA_driver_far)<0) exit(1);
	if(registerfarbgidriver(Herc_driver_far)<0) exit(1);
	if(registerfarbgifont(triplex_font_far)<0) exit(1);
	if(registerfarbgifont(small_font_far)<0) exit(1);
	if(registerfarbgifont(sansserif_font_far)<0) exit(1);
	if(registerfarbgifont(gothic_font_far)<0) exit(1);

	GraphDriver=DETECT;

	initgraph(&GraphDriver,&GraphMode,"");
	ErrorCode=graphresult();
	if(ErrorCode!=grOk){
		printf("Graphics system error: %s\n",grapherrormsg(ErrorCode));
		exit(1);
		}
	getpalette(&palette);
	MaxColors=getmaxcolor()+1;

	MaxX=getmaxx();
	MaxY=getmaxy();

	getaspectratio(&xasp,&yasp);
	AspectRatio=(double)xasp/(double)yasp;
return;
}
title()
{
	struct viewporttype vp; /***    SHOW TITLE SCREEN  ***/


	getviewsettings(&vp);
	setcolor(13);
	settextstyle(4,HORIZ_DIR,7);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	outtextxy(325,40,"Fantasy Dungeon");
	outtextxy(325,120,"Builder");
	settextstyle(2,HORIZ_DIR,4);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	setcolor(4);
	outtextxy(318,165,"unregistered V2.1 Copyright (c) 1993,1994 Perry Horner");
	setcolor(LIGHTGREEN);
	settextstyle(3,HORIZ_DIR,3);
	settextjustify(CENTER_TEXT,BOTTOM_TEXT);
	outtextxy(22*textwidth("M"),300,"Press any key to start");

	for(;;){
		if(kbhit()) break;

		}
return;
}
void numroom(int TILE, int Z)
{
  char p[4]={"    "};
  char pc[1]={" "};


  if((TILE==8)&&(Z==4)) {

		itoa(max_room,p,10);

		 *((T[TILE][Z][0])+3)=*p;
		 *((T[TILE][Z][0])+4)=*pc;
		if(max_room>9) *((T[TILE][Z][0])+4)=*(p+1);
		if(max_room>99) *((T[TILE][Z][0])+5)=*(p+2);

		max_room++;
		}
  if((TILE==11)&&(Z==4)) {

		itoa(max_room,p,10);

		*((T[TILE][Z][0])+3)=*p;
		*((T[TILE][Z][0])+4)=*pc;
		if(max_room>9) *((T[TILE][Z][0])+4)=*(p+1);
		if(max_room>99) *((T[TILE][Z][0])+5)=*(p+2);

		max_room++;
		}

  if((TILE==12)&&(Z==4)) {

		itoa(max_room,p,10);

		*((T[TILE][Z][0])+3)=*p;
		*((T[TILE][Z][0])+4)=*pc;
		if(max_room>9) *((T[TILE][Z][0])+4)=*(p+1);
		if(max_room>99) *((T[TILE][Z][0])+5)=*(p+2);

		max_room++;
		}

  if((TILE==13)&&(Z==4)) {

		itoa(max_room,p,10);

		*((T[TILE][Z][0])+3)=*p;
		*((T[TILE][Z][0])+4)=*pc;
		if(max_room>9) *((T[TILE][Z][0])+4)=*(p+1);
		if(max_room>99) *((T[TILE][Z][0])+5)=*(p+2);

		max_room++;
		}

  if((TILE==14)&&(Z==4)) {

		itoa(max_room,p,10);

		*((T[TILE][Z][0])+3)=*p;
		*((T[TILE][Z][0])+4)=*pc;
		if(max_room>9) *((T[TILE][Z][0])+4)=*(p+1);
		if(max_room>99) *((T[TILE][Z][0])+5)=*(p+2);

		max_room++;
		}
  if((TILE==38)&&(Z==4)){

		itoa(max_room,p,10);

		*((T[TILE][Z][0])+3)=*p;
		*((T[TILE][Z][0])+4)=*pc;
		if(max_room>9) *((T[TILE][Z][0])+4)=*(p+1);
		if(max_room>99) *((T[TILE][Z][0])+5)=*(p+2);

		max_room++;
		}
return;
}

print_map()
{
  int tile;
  textcolor(5);
  gotoxy(30,15);
  if(pron==1) cprintf("Printing map...       ");
  if(dsk==1)  cprintf("Saving map to file... ");
  tileinit();
  for(y=1;y<=size;y++){
	for(z=1;z<=8;z++){
	   for(x=1;x<=9;x++){
		 tile=MAP[y][x];

				numroom(tile,z);

				if(pron==1) Print(*T[tile][z],0);
				if(dsk==1) fputs(*T[tile][z],wp);
			}

	   if(pron==1) Print("",1);
	   if(dsk==1) fputs("\n",wp);
	   }
  }

  if(pron==1)
	Print ("*****************************CUT HERE****************************",1);
  if(dsk==1) {
    fputs("*****************************CUT HERE****************************",wp);
     fputs("\n",wp);
     }
  tileinit();
  for(y=1;y<=size;y++){
	for(z=1;z<=8;z++){
	   for(x=10;x<=18;x++){
		tile=MAP[y][x];

				numroom(tile,z);

				if(pron==1) Print(*T[tile][z],0);
				if(dsk==1) fputs(*T[tile][z],wp);
			}


	   if(pron==1) Print("",1);
	   if(dsk==1) fputs("\n",wp);
	   }

  }
return;
}
int restore_top(int l)
{       int pt,tst,ts;


	ts=0;


	switch(l){
		case	1:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop1[pt];
					}
					break;

				}
		case	2:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop2[pt];

					}
					break;

				}
		case	3:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop3[pt];
					}
					break;

				}
		case	4:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop4[pt];
					}
					break;

				}
		case	5:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop5[pt];
					}
					break;

				}
		case	6:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop6[pt];
					}
					break;
				}
		case	7:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop7[pt];
					}
					break;
				}
		case	8:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop8[pt];
					}
					break;
				}
		case	9:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop9[pt];
					}
					break;
				}
		case	10:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop10[pt];
					}
					break;
				}
		case	11:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop11[pt];
					}
					break;
				}
		case	12:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop12[pt];
					}
					break;
				}
		case	13:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop13[pt];
					}
					break;
				}
		case	14:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop14[pt];
					}
					break;
				}
		case	15:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop15[pt];
					}
					break;
				}
		case	16:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop16[pt];
					}
					break;
				}
		case	17:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop17[pt];
					}
					break;
				}
		case	18:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop18[pt];
					}
				       break;
				}
		case	19:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop19[pt];
					}
					break;
				}
		case	20:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop20[pt];
					}
					break;
				}
		case	21:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop21[pt];
					}
					break;
				}
		case	22:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop22[pt];
					}
					break;
				}
		case	23:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop23[pt];
					}
					break;
				}
		case	24:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop24[pt];
					}
					break;
				}
		case	25:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop25[pt];
					}
					break;
				}
		case	26:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop26[pt];
					}
					break;
				}
		case	27:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop27[pt];
					}
					break;
				}
		case 	28:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop28[pt];
					}
					break;
				}
		case 	29:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop29[pt];
					}
					break;
				}
		case	30:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop30[pt];
					}
					break;
				}
		case	31:	{for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop31[pt];
					}
					break;
				}
		case	32:	{for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop32[pt];
					}
					break;
				}
		case	33:	{for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop33[pt];
					}
					break;
				}
		case	34:	{for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop34[pt];
					}
					break;
				}
		case	35:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop35[pt];
					}
					break;
				}
		case	36:	{for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop36[pt];
					}
					break;
				}
		case    37:	{for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop37[pt];
					}
					break;
				}
		case	38:	{for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAtop38[pt];
					}
					break;
				}

		default  :	break;


		}
		y=(cy-1);
		tst=MAP[y][cx];
		ts=0;

		for(pt=0;pt<=19;pt++){

		       if(tst==DATAdum[pt]) {ts=1;break;}
		       }

		return ts;
}

int restore_left(int l)
{
	int pt,tst,ts;

	ts=0;

	switch(l){
		case	0:	exit(0);

		case	1:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft1[pt];

					}
				break;

				}
		case	2:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft2[pt];
					}
					break;
				}
		case	3:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft3[pt];
					}
					break;
				}
		case	4:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft4[pt];
					}
					break;
				}
		case	5:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft5[pt];
					}
					break;
				}
		case	6:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft6[pt];
					}
					break;
				}
		case	7:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft7[pt];
					}
					break;
				}
		case	8:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft8[pt];
					}
					break;
				}
		case	9:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft9[pt];
					}
					break;
				}
		case	10:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft10[pt];
					}
					break;
				}
		case	11:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft11[pt];
					}
					break;
				}
		case	12:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft12[pt];
					}
					break;
				}
		case	13:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft13[pt];
					}
					break;
				}
		case	14:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft14[pt];
					}
					break;
				}
		case	15:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft15[pt];
					}
					break;
				}
		case	16:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft16[pt];
					}
					break;
				}
		case	17:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft17[pt];
					}
					break;
				}
		case	18:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft18[pt];
					}
					break;
				}
		case	19:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft19[pt];
					}
					break;
				}
		case	20:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft20[pt];
					}
					break;
				}
		case	21:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft21[pt];
					}
					break;
				}
		case	22:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft22[pt];
					}
					break;
				}
		case	23:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft23[pt];
					}
					break;
				}
		case	24:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft24[pt];
					}
					break;
				}
		case	25:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft25[pt];
					}
					break;
				}
		case	26:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft26[pt];
					}
					break;
				}
		case	27:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft27[pt];
					}
					break;
				}
		case	28:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft28[pt];
					}
					break;
				}
		case	29:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft29[pt];
					}
					break;
				}
		case	30:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft30[pt];
					}
					break;
				}
		case	31:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft31[pt];
					}
					break;
				}
		case	32:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft32[pt];
					}
					break;
				}
		case	33:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft33[pt];
					}
					break;
				}
		case	34:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft34[pt];
					}
					break;
				}
		case	35:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft35[pt];
					}
					break;
				}
		case	36:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft36[pt];
					}
					break;
				}
		case	37:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft37[pt];
					}
					break;
				}
		case	38:	{
				for(pt=0;pt<=19;pt++){
					DATAdum[pt]=DATAleft38[pt];
					}
					break;
				}



		default	:	break;

		}
		pt=0;
		ts=0;
		x=cx-1;
		tst=MAP[cy][x];

		for(pt=0;pt<=19;pt++){

			if(tst==DATAdum[pt]) { ts=1;break;}

		}

		return  ts;
}
int isroom()
{
		       if((i==26)&&(dummy==27)) {return 0;}
		       dummy=i;


			if(i==8) {
					tileinit();
					room++;
					secret();
					}
			if(i==11) {
					tileinit();
					room++;
					secret();
					}
			if(i==12) {     tileinit();
					room++;
					secret();
					}
			if(i==13) {     tileinit();
					room++;
					secret();
					}
			if(i==14) {     tileinit();
					room++;
					secret();
					}
			if(i==38) {     tileinit();
					room++;
					secret();
					}
return 1;
}

void checking(void)
{

int CHECK,lcheck,tcheck,qst;

lcheck=0;
tcheck=0;
CHECK=0;
qst=0;
  for(cy=2;cy<=size;cy++){
	for(cx=1;cx<=18;cx++){
		CHECK=0;


	for(;;){
			CHECK=0;
			lcheck=0;
			tcheck=0;
			i=(random(38)+1);

			gotoxy(30,15);
			textcolor(YELLOW);
			cprintf("Working On Room %d",room);



			if((cy-1)>0) tcheck=restore_top(i);
			lcheck=0;
			if (tcheck==1){
				if((cx-1)>=0) lcheck=restore_left(i);
			}


		if(cx==1) switch(i){
				case 3: 	{tcheck=0;
						break;
						}
				case 5: 	{tcheck=0;
						break;
						}
				case 6: 	{tcheck=0;
						break;
						}
				case 7: 	{tcheck=0;
						break;
						}
				case 1: 	{tcheck=0;
						break;
						}
				case 9: 	{tcheck=0;
						break;
						}
				case 16: 	{tcheck=0;
						break;
						}
				case 19: 	{tcheck=0;
						break;
						}
				case 20: 	{tcheck=0;
						break;
						}
				case 23: 	{tcheck=0;
						break;
						}
				case 26: 	{tcheck=0;
						break;
						}
				case 28:	{tcheck=0;
						break;
						}
				case 29:	{tcheck=0;
						break;
						}
				case 31:	{tcheck=0;
						break;
						}
				case 34:	{tcheck=0;
						break;
						}
				case 35:	{tcheck=0;
						break;
						}
				case 37:	{tcheck=0;
						break;
						}
				case 38:	{tcheck=0;
						break;
						}
				default: 	break;
			       }
		if(cy==size) switch(i){
				case 8:		{tcheck=0;
						break;
						}
				case 5:		{tcheck=0;
						break;
						}
				case 6:		{tcheck=0;
						break;
						}
				case 1:		{tcheck=0;
						break;
						}
				case 10:	{tcheck=0;
						break;
						}
				case 2:		{tcheck=0;
						break;
						}
				case 14:	{tcheck=0;
						break;
						}
				case 15:	{tcheck=0;
						break;
						}
				case 20:	{tcheck=0;
						break;
						}
				case 21:	{tcheck=0;
						break;
						}
				case 22:	{tcheck=0;
						break;
						}
				case 23:	{tcheck=0;
						break;
						}
				case 25:	{tcheck=0;
						break;
						}
				case 32:	{tcheck=0;
						break;
						}
				case 36:	{tcheck=0;
						break;
						}
				case 38:	{tcheck=0;
						break;
						}
				default:	break;
				}

		if(cx==18) switch(i){
				case 2:	{tcheck=0;
					 break;
					 }

				case 4:	{tcheck=0;
					 break;
					 }
				case 5:	{tcheck=0;
					 break;
					 }
				case 6:	{tcheck=0;
					 break;
					 }
				case 7:	{tcheck=0;
					 break;
					 }
				case 9:	{tcheck=0;
					 break;
					 }
				case 16: {tcheck=0;
					  break;
					  }
				case 18: {tcheck=0;
					  break;
					  }
				case 21: {tcheck=0;
					  break;
					  }
				case 22: {tcheck=0;
					  break;
					  }
				case 27: {tcheck=0;
					  break;
					  }
				case 28: {tcheck=0;
					  break;
					  }
				case 29: {tcheck=0;
					  break;
					  }
				case 30: {tcheck=0;
					  break;
					  }
				case 34: {tcheck=0;
					  break;
					  }
				case 35: {tcheck=0;
					  break;
					  }
				case 36: {tcheck=0;
					  break;
					  }
				case 37: {tcheck=0;
					  break;
					  }
				case 38: {tcheck=0;
					  break;
					  }
				default:  break;

			}

			if((lcheck==1)&&(tcheck==1)) {
					qst=isroom();
					if(qst==0) break;
					MAP[cy][cx]=i;
					CHECK=1;
					}



			if(CHECK==1) break;
		}

	}

  }
  return;
}

create_map()
{


	for(y=0;y<=63;y++){
		for(x=0;x<=20;x++){
			 MAP[y][x]=17;
			/******PROTO*******/

		 }
	}

	clrscr();


			checking();



return;
}






inquire_size()
{
	int select,s1,s2,s3,p,wn;
	s1=1;
	pron=1;
	size=8;
	s2=s3=0;

randomize();

clrscr();
	textcolor(14);
	gotoxy(28,7);
	putch(201);
	for(wn=29;wn<=52;wn++){
		gotoxy(wn,7);
		putch(205);
		}
	gotoxy(53,7);
	putch(187);
	for(wn=8;wn<=19;wn++){
		gotoxy(28,wn);
		putch(186);
		gotoxy(53,wn);
		putch(186);
		}
	gotoxy(28,20);
	putch(200);
	for(wn=29;wn<=52;wn++){
		gotoxy(wn,20);
		putch(205);
		}
	gotoxy(53,20);
	putch(188);
gotoxy(30,4);
cprintf("=unregistered  version=");
gotoxy(30,5);
textcolor(12);
cprintf("DUNGEON SIZE & OUTPUT");
gotoxy(30,5);

pron=1;
dsk=0;
	for(;;){
		gotoxy(30,18);
		textcolor(13);
		cprintf("6=DONE");

		if(s1==0) textcolor(13);
		if(s1==1) textcolor(15);
			gotoxy(30,8);
			cprintf("1=small (8-24 rooms)");

			if(s2==0) textcolor(13);
			if(s2==1) textcolor(15);
				gotoxy(30,10);
				cprintf("2=medium (24-48 rooms)");

			if(s3==0) textcolor(13);
			if(s3==1) textcolor(15);
				gotoxy(30,12);
				cprintf("3=large (48-128 rooms)");
				gotoxy(30,14);
		if(pron==0) textcolor(13);
			if(pron==1) textcolor(15);
				cprintf("4=print to printer");
				gotoxy(30,16);
			if(dsk==0) textcolor(13);
			if(dsk==1) textcolor(15);
				cprintf("5=print to disk");

	select=Pause();
	sound(100);
	delay(200);
	nosound();
	if(select==49) {size=8;s1=1;s2=0;s3=0;}
	if(select==54) break;
	if(select==52) {pron=1;dsk=0;}
	}


return;
}




interior()
{
  int rn;
  int rl,clevel;
  char *ml[8];
  char st[81];

  clrscr();
  gotoxy(5,5);
  textcolor(YELLOW);
  cprintf("Dungeon level-%d",sdunlevel);
  gotoxy(5,6);
  cprintf("What level of characters will be going on this dungeon level? ");
  textcolor(RED);
  gotoxy(68,6);
  gets(st);
  clevel=atoi(st);

  textcolor(YELLOW);

  if(pron==1){ clrscr();
	printf("\n\nPlease align printer paper and press RETURN\n");
	for(;;){
		if(kbhit()) break;
		}
	}
	clrscr();
	gotoxy(30,15);

	if(pron==1) cprintf("Printing module...");
	if(dsk==1)  {
		gotoxy(25,15);
		cprintf("Saving module to file ");
		gotoxy(48,15);
		textcolor(RED);
		cprintf("DLEV%d.MOD",sdunlevel);
		textcolor(YELLOW);
		}
  if(pron==1){
	Print("========================================================",3);
	Print("                          LEVEL ",0);
	itoa(sdunlevel,ml,10);
	Print(ml,3);

	Print("                  For characters of level ",0);
	itoa(clevel,ml,10);
	Print(ml,0);
	Print(" or higher",3);
	Print("The gamemaster should look over this module and find a suitable",1);
	Print("starting position as an entrance.  Also make any modifications to",1);
	Print("the dungeon map such as connecting unconnected rooms and",1);
	Print("passageways.  Possibly having teleports to the different parts",1);
	Print("or levels.  Something else that can be done is connecting by using",1);
	Print("a pencil, the underground waterways.  This can make running the",1);
	Print("dungeon interesting.",3);
	}
	if(dsk==1){
	     fputs("========================================================\n\n\n",wp);
	     fputs("                         LEVEL ",wp);
	     itoa(sdunlevel,ml,10);
	     fputs(ml,wp);
	     fputs("\n\n\n",wp);
	     fputs("        For characters of level ",wp);
	     itoa(clevel,ml,10);
	     fputs(ml,wp);
	     fputs(" or higher\n\n\n",wp);
	     fputs("The gamemaster should look over this module and find a suitable\n",wp);
	     fputs("starting position as an entrance.  Also make any modifications\n",wp);
	     fputs("to the dungeon map such as connecting unconnected rooms and\n",wp);
	     fputs("passageways.  Possibly having teleports to the different parts\n",wp);
	     fputs("or levels.  Something else that can be done is connecting by\n",wp);
	     fputs("using a pencil, the underground waterways.  This can make running\n",wp);
	     fputs("the dungeon interesting.\n\n\n",wp);
		}

	level=(clevel/3);
	if(level<1) level=1;

	roaming();

	for(rn=1;rn<=room;rn++){
	   rl=(random(28)+1);
	 if(pron==1){
	   Print("",1);
	   Print("Room ",0);
	   itoa(rn,ml,10);
	   Print(ml,1);
	   Print("----",1);
	   }
	   if(dsk==1) fputs("\nRoom ",wp);
	   if(dsk==1) itoa(rn,ml,10);
	   if(dsk==1) fputs(ml,wp);
	   if(dsk==1) fputs("\n",wp);
	   if(dsk==1) fprintf("----\n",wp);

	   if(rl<5){
		if(pron==1) Print("****Empty Room****",2);
		if(dsk==1) fputs("****Empty Room****\n\n",wp);
		   }
	   if(rl>=5) { roomname();
			desc();
			}
	   if((rl>=5)&&(rl<=13)) monster();
	   if((rl>=14)&&(rl<=20)) monster_tr();
	   if(rl==21) {
	       if(pron==1) Print("There are stairs in this room leading (to the surface or ",1);
	       if(pron==1)Print("to a level below).",2);
	       if(dsk==1) fputs("There are stairs in this room leading (to the surface or\n",wp);
	       if(dsk==1) fputs("to a level below).\n\n",wp);
			}
	   if((rl>=22)&&(rl<25)) trap();
	   if(rl>=25) contents();


	 }


return;
}

monster()
{
  int l;

  l=(random(level)+1);

  mlevel(l);
}

roaming()
{
  int l;
  int t;
  int r,s,q,count,ar,at,hd,num;
  char *f[12];
  char dum[81];
  char item[81];
  char *ml[8];

  l=(random(level)+1);

  if(l==1) *f="level1.tbl";
  if(l==2) *f="level2.tbl";
  if(l==3) *f="level3.tbl";
  if(l==4) *f="level4.tbl";
  if(l==5) *f="level5.tbl";
  if(l==6) *f="level6.tbl";
  if(l==7) *f="level7.tbl";
  if(l==8) *f="level8.tbl";
  if(l==9) *f="level9.tbl";
  if(l>=10) *f="level10.tbl";


  r=0;

  at=0;
  hd=0;
  ar=0;


	if(pron==1) Print("ROAMING MONSTER TABLE:",1);
	if(dsk==1) fputs("ROAMING MONSTER TABLE:\n",wp);
  t=0;
  for(t=1;t<=6;t++){
	r=0;

	fp=fopen(*f,"r");
	for(;;){
		if(feof(fp)) break;
		fgets(item,80,fp);
		if(item[0]=='@') break;
		if(feof(fp)) break;
		if(item[0]!='@') r++;
		}

	fclose(fp);
	q=(r/4);
	r=q;
  s=(random(r)+1);
  fp=fopen(*f,"r");
    for(r=1;r<=s;r++){
	if(feof(fp)) break;
	fgets(item,80,fp);
	if(item[0]=='@') break;
	fgets(dum,10,fp);
	if(dum[0]=='@') break;
	ar=atoi(dum);
	fgets(dum,10,fp);
	hd=atoi(dum);
	fgets(dum,10,fp);
	/* num=atoi(*dum); */
	if(feof(fp)) break;
    }
    fclose(fp);


    itoa(t,ml,10);
    if(pron==1) Print(ml,0);
    if(pron==1) Print(".   ",0);
    if(dsk==1)  fputs(ml,wp);
    if(dsk==1)  fputs(".   ",wp);
    if(dsk==1)  fputs(item,wp);
    if(pron==1) Print(item,0);
    if(pron==1) Print("     AR:",0);
    if(dsk==1) fputs("     AR:",wp);
    itoa(ar,ml,10);
    if(pron==1) Print(ml,0);
    if(dsk==1) fputs(ml,wp);
    if(dsk==1) fputs(" ",wp);
    if(pron==1) Print("  AD:",0);
    if(dsk==1) fputs("  AD:",wp);
    itoa(hd,ml,10);
    if(pron==1) Print(ml,1);
    if(dsk==1) fputs(ml,wp);
    if(dsk==1) fputs("\n",wp);
    }

   if(pron==1) Print(" ",3);
   if(dsk==1) fputs("\n\n\n",wp);
}
monster_tr()
{
  int l,pc;
  int o,p,count;
  char *ml[8];

  l=(random(level)+1);
  mlevel(l);

  if(pron==1) Print    ("There is also some treasure in this room.",1);
  if(dsk==1) fputs("There is also some treasure in this room.\n",wp);
  if(pron==1) Print("There is the following:",1);
  if(dsk==1) fputs("There is the following:\n",wp);
  p=(random(level)+1);
  for(count=0;count<p;count++){

  o=(random(12)+1);

  if(o==1) { itoa((1000*level),ml,10);
	     if(pron==1) Print(ml,0);
	     if(pron==1) Print(" copper pieces",1);
	     if(dsk==1) fputs(ml,wp);
	     if(dsk==1) fputs(" copper pieces\n",wp);
	     }

  if(o==2) {    itoa((random(1000*level)+1),ml,10);
		if(pron==1) Print(ml,0);
		if(pron==1) Print(" silver pieces",1);
		if(dsk==1) fputs(ml,wp);
		if(dsk==1) fputs(" silver pieces\n",wp);
		}

  if(o==3) {
		itoa((random(750*level)+1),ml,10);
		if(pron==1) Print(ml,0);
		if(pron==1) Print(" electrum pieces",1);
		if(dsk==1) fputs(ml,wp);
		if(dsk==1) fputs(" electrum pieces\n",wp);
		}

  if(o==4) {
		itoa((random(250*level)+1),ml,10);
		if(pron==1) Print(ml,0);
		if(pron==1) Print(" gold pieces",1);
		if(dsk==1) fputs(ml,wp);
		if(dsk==1) fputs(" gold pieces\n",wp);
		}

  if(o==5) { 	itoa((random(100*level)+1),ml,10);
		if(pron==1) Print(ml,0);
		if(pron==1) Print(" platinum pieces",1);
		if(dsk==1) fputs(ml,wp);
		if(dsk==1) fputs(" platinum pieces\n",wp);
		}

  if(o==6) {
		itoa(((random(4)+1)),ml,10);
		if(pron==1) Print(ml,0);
		if(pron==1) Print(" gems worth ",0);
		if(dsk==1) fputs(ml,wp);
		if(dsk==1) fputs(" gems worth ",wp);
		itoa(((random(50)*10)),ml,10);
		if(pron==1) Print(ml,0);
		if(pron==1) Print(" gold pieces",1);
		if(dsk==1) fputs(ml,wp);
		if(dsk==1) fputs(" gold pieces\n",wp);
		}

  if(o==7) {    itoa(((random(4)+level)),ml,10);
		if(pron==1) Print(ml,0);
		pc=(random(4)+level);
		if(dsk==1) fputs(ml,wp);
		if(pron==1) Print(" pieces of jewelry worth ",0);
		if(dsk==1) fputs(" pieces of jewelry worth ",wp);
		itoa(((random(100)*100)),ml,10);
		if (pron==1) Print(ml,0);
		if(pron==1) Print(" gold pieces",1);
		if(dsk==1) fputs(ml,wp);
		if(dsk==1) fputs(" gold pieces\n",wp);
		}

  if(o>=8) magic();
  container();
  }
}

magic(void)
{
 int tb1,tb2,tb3,tb4;

 tb1=0;
 tb2=0;
 tb3=0;
 tb4=0;

 if(level==1) tb1=1;
 if(level==2) tb1=2;
 if(level==3) {tb1=2;tb2=1;}
 if(level==4) {tb1=2;tb2=1;}
 if(level==5) {tb1=3;tb2=1;}
 if(level==6) {tb1=3;tb2=2;}
 if(level==7) {tb1=3;tb2=3;}
 if(level==8) {tb1=3;tb2=2;tb3=1;}
 if(level==9) {tb1=3;tb2=2;tb3=1;}
 if(level==10){tb1=3;tb2=2;tb3=1;}
 if(level==11){tb1=3;tb2=2;tb3=1;tb4=1;}
 if(level==12){tb1=3;tb2=2;tb3=2;tb4=1;}
 if(level>12) {tb1=3;tb2=2;tb3=2;tb4=2;}

 table(tb1,tb2,tb3,tb4);
return;
}

container(void)
{
int o,r,s,count;
char ch[1]={"*"};
char st[81];

	if(pron==1) Print("These items are contained in ",0);
	if(dsk==1) fputs("These items are contained in ",wp);
	r=0;
	fp=fopen("containr.tbl","r");
		for(;;){
		if(feof(fp)) break;
		fgets(st,80,fp);
		if(st[0]=='@') break;
		if(feof(fp)) break;
		if(st[0]==ch[0]) r++;
		}

		fclose(fp);
		r=r-1;
		s=(random(r)+1);
		fp=fopen("containr.tbl","r");

			count=0;
			for(;;){
				if(feof(fp)) break;
				fgets(st,80,fp);
				if(st[0]=='@') break;
				if(feof(fp)) break;
				if(st[0]==ch[0]) count++;
				if(count==s) break;
				}

				for(;;){

					fgets(st,80,fp);
					if(st[0]=='@') break;
					if(feof(fp)) break;
					if(st[0]==ch[0]) break;
					if(pron==1) Print(st,0);
					if(dsk==1) fputs(st,wp);

				}



		fclose(fp);



	o=(random(100)+1);   /*trap*/
	if(o<17) {
		if(pron==1) Print("The tresure has a trap. (if applicable)-",1);
		if(dsk==1) fputs("The treasure has a trap (if applicable)-\n",wp);
		if(pron==1) Print("          ",1);
		if(dsk==1) fputs("             ",wp);
	r=0;
	fp=fopen("contrap.tbl","r");
		for(;;){
		if(feof(fp)) break;
		fgets(st,80,fp);
		if(st[0]=='@') break;
		if(feof(fp)) break;
		if(st[0]==ch[0]) r++;
		}

		fclose(fp);
		r=r-1;
		s=(random(r)+1);

		fp=fopen("contrap.tbl","r");
		count=0;
			for(;;){
				if(feof(fp)) break;
				fgets(st,80,fp);
				if(st[0]=='@') break;
				if(feof(fp)) break;
				if(st[0]==ch[0]) count++;
				if(count==s) break;
				}

			for(;;){
				if(feof(fp)) break;
				fgets(st,80,fp);
				if(st[0]=='@') break;
				if(feof(fp)) break;
				if(st[0]==ch[0]) break;
				if(pron==1) Print(st,0);
				if(dsk==1) fputs(st,wp);
			}

		}
		fclose(fp);
		if(pron==1) Print(" ",1);
		if(dsk==1) fputs("\n",wp);
return;
}


table(int t1, int t2, int t3, int t4)
{
	int count;
	int r,s,tb;
	char *f[12];

	if(t1>0) {
		*f="magic1.tbl";
		table_c(f,t1);
		 }
	if(t2>0) {
		*f="magic2.tbl";
		table_c(f,t2);
		}
	if(t3>0) {
		*f="magic3.tbl";
		table_c(f,t3);
		}
	if(t4>0) {
		*f="magic4.tbl";
		table_c(f,t4);
		}
return;
}



table_c(char *f[12], int t)
{

	FILE *fp;
	int r,s,count;
	char item[81];

	if(t>0){
			if((fp=fopen(*f,"r"))==NULL){
			printf("\n\nFile cannot be opened: %s\n",*f);
			exit(1);
			}
			r=0;
			for(;;){
				if(feof(fp)) break;
				fgets(item,80,fp);
				if(item[0]=='@') break;

				if(item[0]!='@') r++;
				if(feof(fp)) break;
			}
			fclose(fp);
			for(count=1;count<=t;count++){
			  fp=fopen(*f,"r");
			  s=(random(r)+1);
			  for(r=1;r<=s;r++){
				if(feof(fp)) break;
				fgets(item,80,fp);
				if(item[0]=='@') break;
				if(feof(fp)) break;
			  }
			  if(pron==1) Print("   ",0);
			  if(pron==1) Print(item,0);
			  if(dsk==1) fputs("     ",wp);
			  if(dsk==1) fputs(item,wp);

			  fclose(fp);
			}
		} /*end if of 0 */
fclose(fp);
return;
}


trap()
{
int r,s,count;
char ch[1]={"*"};
char st[81];



	if(pron==1) Print("There is a trap in this room.",1);
	if(dsk==1) fputs("There is a trap in this room.\n",wp);

	r=0;
	  fp=fopen("trap.tbl","r");
		for(;;){

		if(feof(fp)) break;
		fgets(st,80,fp);
		if(st[0]=='@') break;
		if(feof(fp)) break;
		if(st[0]==ch[0]) r++;
		}
		fclose(fp);
		r=r-1;

		s=(random(r)+1);

		fp=fopen("trap.tbl","r");
		count=0;

			for(;;){
				if(feof(fp)) break;
				fgets(st,80,fp);
				if(st[0]=='@') break;
				if(feof(fp)) break;
				if(st[0]==ch[0]) count++;
				if(count==s) break;
			}

			for(;;){
				if(feof(fp)) break;
				fgets(st,80,fp);
				if(st[0]=='@') break;
				if(feof(fp)) break;
				if(st[0]==ch[0]) break;
				if(pron==1) Print(st,0);
				if(dsk==1) fputs(st,wp);

		       }
		fclose(fp);

}


roomname()
{
int r,s,count,ss;

char item[81];
FILE *fp;
r=0;

	if((fp=fopen("rmname.tbl","r"))==NULL){
		printf("\n\nFile cannot be opened - rmname.tbl\n");
		exit(1);
		}

	for(;;){
		if(feof(fp)) break;
		fgets(item,80,fp);
		if(item[0]=='@') break;
		if(item[0]!='@') r++;
		if(feof(fp)) break;

	}
		fclose(fp);
		s=(random(r)+1);
		fp=fopen("rmname.tbl","r");
		for(count=1;count<=s;count++){
			if(feof(fp)) break;
			fgets(item,80,fp);
			if(item[0]=='@') break;
			if(feof(fp)) break;
		}

		fclose(fp);
		if(pron==1) Print(item,1);
		if(dsk==1) {fputs(item,wp);
				fputs("\n",wp);
			    }
}
desc()
{
int r,s,count;
char ch[1]={"*"};
char st[81];

	r=0;
	fp=fopen("descrpt.tbl","r");
	for(;;){
	if(feof(fp)) break;
	fgets(st,80,fp);
	if(st[0]=='@') break;
	if(st[0]==ch[0]) r++;
	if(feof(fp)) break;
	}
	fclose(fp);
	r=r-1;

	s=(random(r)+1);

	fp=fopen("descrpt.tbl","r");
	for(count=1;count<=s;count++){
		for(;;){
			if(feof(fp)) break;
			fgets(st,80,fp);
			if(st[0]=='@') break;
			if(st[0]==ch[0]) break;
			if(feof(fp)) break;
		}
	}
		for(;;){
			if(feof(fp)) break;
			fgets(st,80,fp);
			if(st[0]=='@') break;
			if(feof(fp)) break;
			if(st[0]==ch[0]) break;
			if(pron==1) Print(st,0);
			if(dsk==1) fputs(st,wp);

		}
		fclose(fp);

}
contents()
{
	char *ml[8];
	int r,s,count,ss;
	char item[81];

	FILE *fp;
	r=0;
	if(pron==1) Print("This room contains the following: ",1);
	if(dsk==1) fputs("This room contains the following:\n",wp);

	if((fp=fopen("contents.tbl","r"))==NULL){
		printf("\n\nFile cannot be opened: contents.tbl\n");
		exit(1);
		}
	ss=(random(10)+1);
	for(;;){
		if(feof(fp)) break;
		fgets(item,80,fp);
		if(item[0]=='@') break;
		if(item[0]!='@') r++;
		if(feof(fp)) break;

	}
	fclose(fp);
	for(count=1;count<=ss;count++){
		fp=fopen("contents.tbl","r");
		s=(random(r)+1);
		for(r=1;r<=s;r++){
			if(feof(fp)) break;
			fgets(item,80,fp);
			if(item[0]=='@') break;
			if(feof(fp)) break;
		}
		if(pron==1) Print("        ",0);
		if(dsk==1) fputs("        ",wp);
		if(pron==1) Print(item,0);
		if(dsk==1) fputs(item,wp);

		fclose(fp);
	}
fclose(fp);
}



mlevel(int l)
{
	int r,s,count;
	int ac,hp,hd,num;
	char *f[12];
	char dum[81];
	char *ml[8];
	char item[81];
	FILE *fp;

       if(l==1) *f="level1.tbl";
       if(l==2) *f="level2.tbl";
       if(l==3) *f="level3.tbl";
       if(l==4) *f="level4.tbl";
       if(l==5) *f="level5.tbl";
       if(l==6) *f="level6.tbl";
       if(l==7) *f="level7.tbl";
       if(l==8) *f="level8.tbl";
       if(l==9) *f="level9.tbl";
       if(l>=10) *f="level10.tbl";

       if((fp=fopen(*f,"r"))==NULL){
		printf("\n\nFile cannot be opened: %s\n",*f);
		exit(1);
       }
       fclose(fp);
       r=0;

       hp=0;   /*hit points*/
       hd=0;   /*hit die*/
       ac=0;   /*armor class*/
       num=0;   /*number appearing*/
       fp=fopen(*f,"r");
       for(;;){
		if(feof(fp)) break;
		fgets(item,80,fp);
		if(item[0]=='@') break;
		if(item[0]!='@') r++;
		if(feof(fp)) break;

       }
       fclose(fp);
       r=(r/4);
       s=(random(r)+1);
       fp=fopen(*f,"r");
	for(r=1;r<=s;r++){
		if(feof(fp)) break;
		fgets(item,80,fp);
		if(item[0]=='@') break;
		fgets(dum,10,fp);
		if(dum[0]=='@') break;
		ac=atoi(dum);
		fgets(dum,10,fp);
		if(dum[0]=='@') break;
		hd=atoi(dum);
		fgets(dum,10,fp);
		if(dum[0]=='@') break;
		num=atoi(dum);
		if(feof(fp)) break;
	}
	fclose(fp);
	s=(random(num)+1);
	num=s;
	if(pron==1) Print("Number of monsters in this room: ",0);
	if(dsk==1) fputs("Number of monsters in this room: ",wp);
	itoa(num,ml,10);
	if(pron==1) Print(ml,1);
	if(dsk==1) fputs(ml,wp);
	if(dsk==1) fputs("\n",wp);

	for(r=1;r<=num;r++){
		hp=(random((8*hd))+1);
		if(pron==1) Print("MONSTER: ",0);
		if(dsk==1) fputs("MONSTER:  ",wp);

		if(pron==1) Print(item,0);
		if(dsk==1) fputs(item,wp);
		if(dsk==1) fputs(" ",wp);

		if(pron==1) Print("          AR: ",0);
		if(dsk==1) fputs("         AR: ",wp);
		itoa(ac,ml,10);
		if(pron==1) Print(ml,0);
		if(dsk==1) fputs(ml,wp);

		if(pron==1) Print("AP: ",0);
		if(dsk==1) fputs(" AP: ",wp);

		itoa(hp,ml,10);
		if(pron==1) Print(ml,1);
		if(dsk==1) fputs(ml,wp);
		if(dsk==1) fputs("\n",wp);

	}
return;
}

